<?php

App::uses('EvCatalogueAppController', 'EvCatalogue.Controller');

class CategoriesController extends EvCatalogueAppController {

/**
 * Called before the controller action.
 *
 * @return void
 * @link http://book.cakephp.org/2.0/en/controllers.html#request-life-cycle-callbacks
 */
	public function beforeFilter() {
		parent::beforeFilter();

		// Allow front end users to access these actions without having to log in
		$this->Auth->allow([
			'view',
			'brands'
		]);
	}

/**
 * Used to populate form drop down selects
 *
 * @return  void
 */
	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		$this->set('parents', $this->{$this->modelClass}->getForDropDown([
			'order' => [
				$this->{$this->modelClass}->alias . '.name' => 'ASC'
			]
		]));
	}

/**
 * Handles view page for a specified category.  The index and view must be the same becaue we are
 * using the routable plugin
 *
 * @param int $id ID of category to view
 * @return void
 */
	public function view($id = null) {
		$Model = $this->{$this->modelClass};

		$category = $Model->readForViewOrFail($id);

		// Get parent
		$parent = $Model->readForView($category['Category']['parent_id']);
		if (!empty($parent)) {
			$this->set('catalogueParent', $parent);
		}

		// Get children
		$children = $Model->findAllChildren($id);
		if (!empty($children)) {
			$this->set('catalogueChildren', $children);
		}

		// Get all products
		$this->set('catalogueProducts', $Model->CatalogueItem->readForIndex([
			'conditions' => [
				'CatalogueItem.category_id' => $id
			]
		]));

		$this->set('category', $category);
	}

/**
 * Handles view page for a specified category which has a parent
 *
 * @param int $id ID of category to view
 * @return void
 */
	public function brands($id = null) {
		$Model = $this->{$this->modelClass};

		$category = $Model->readForViewOrFail($id);

		$this->set('cataloguePategory', $category);
		$this->set('catalogueParent', $Model->readForView($category['Category']['parent_id']));
		$this->set('catalogueCategories', $Model->findAllChildren($id));
		$this->set('catalogueProducts', $Model->findAllCatalogueItemsFor($id));
	}
}
