<?php

App::uses('EvCatalogueAppController', 'EvCatalogue.Controller');

class CatalogueItemsController extends EvCatalogueAppController {

/**
 * Called before the controller action. Used to configure and customize components or perform logic
 * that needs to happen before each controller action.
 *
 * @return void
 */
	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'index',
			'view'
		));
	}

/**
 * Used to populate form drop down selects
 *
 * @return  void
 */
	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		$this->loadModel('EvCatalogue.Category');
		$this->set('categories', $this->Category->getForDropDown());
	}

/**
 * Listings page
 *
 * @return void
 */
	public function index() {
		$items = $this->CatalogueItem->find('all', [
			'conditions' => [
				'is_active' => true
			]
		]);

		$this->set('items', $items);
	}

/**
 * CatalogueItem Details page
 *
 * @param string $id of a catalogue item
 * @return void
 */
	public function view($id) {
		$Model = $this->{$this->modelClass};

		$catalogueItem = $Model->readForViewOrFail($id);

		$this->Meta->set($catalogueItem);
		$this->set('catalogueItem', $catalogueItem);
	}
}
