<?php if (isset($categories) && ! empty($categories)): ?>
	<div class="ev-case-studies__widget ev-case-studies__widget--filterByCategory">

		<h2>Filter By Category</h2>

		<?php foreach ($categories as $category): ?>
            <p>
                <?php
                    // Add the current case study category id to the current url
                	$urlForCategory = $currentRoute;
                	if (isset($currentRoute['category']) && !empty($currentRoute['category'])) {
                		if (!in_array($category['CaseStudyCategory']['id'], $currentRoute['category'])) {
                			$urlForCategory['category'][] = $category['CaseStudyCategory']['id'];
                		}

                	} else {
                		$urlForCategory['category'] = [$category['CaseStudyCategory']['id']];
                	}

                	//Remove page parameter as pagination will be updated and the page may not exist
                	if (isset($urlForCategory['page'])) {
                		unset($urlForCategory['page']);
                	}

                    $caseStudyCategoryUrl = Router::url($urlForCategory);

                    echo $this->Html->link($category['CaseStudyCategory']['name'], $caseStudyCategoryUrl);
                ?>
            </p>

        <?php endforeach; ?>

        <?php
        	//Create remove filter link
        	if (isset($currentRoute['category'])) {
        		unset($currentRoute['category']);
        	}

        	//Page has to be removed as well because pagination will change
        	if (isset($currentRoute['page'])) {
        		unset($currentRoute['page']);
        	}

        	$removeFilterUrl = Router::url($currentRoute);
        	echo $this->Html->link('Remove Filters', $removeFilterUrl);
    	?>
    </div>
<?php endif; ?>
