<?php

App::uses('AppHelper', 'View/Helper');

class CaseStudiesHelper extends AppHelper {

/**
 * Get the links for the filterByDate widget. By default the links are by year.
 * @param  int    $maxDateLinks The maximum number of links to display
 * @param  array  $dates        The array of dates that can be displayed
 * @return array                The list of links to be displayed.
 */
	public function getFilterDateLinks($maxDateLinks = 5, $dates = []) {
		$dateLinks = [];
		$yearsToLink = array_keys($dates);

		$lastYear = null;
		foreach ($yearsToLink as $year) {
			if (count($dateLinks) < $maxDateLinks) {
				$newDateLink = [
					'label' => Inflector::slug($year),
					'start' => Inflector::slug($year . '-01-01 00:00:00'),
					'end' => Inflector::slug($year . '-12-31 23:59:59')
				];

				$dateLinks[] = $newDateLink;
			} else {
				//Set last year
				if ($lastYear === null) {
					$lastYear = $year;
				}
			}
		}

		if ($lastYear !== null) {
			//Add Older Than last link
			$dateLinks[] = [
				'label' => 'Older Than ' . $lastYear,
				'end' => Inflector::slug($lastYear . '-12-31 23:59:59')
			];
		}

		return $dateLinks;
	}
}
