<?php
	$caseStudyUrl = $this->Route->getItemRoute('EvCaseStudies', 'CaseStudy');
	$caseStudyUrl[] = $data['CaseStudy']['id'];

	$galleryConf = Configure::read('EvCaseStudies.gallery');
?>
<div class="ev-case-studies__view">
    <h1><?= $data['CaseStudy']['name'] ?></h1>
    <?php
		if(! empty($data['GalleryImage'])):
	?>
	    <div class="ev-case-studies__view__gallery">
	        <ul class="ev-case-studies__view__gallery__images">
		        <?php
					foreach($data['GalleryImage'] as $img):
			            $image = $this->Img->resize($img, [
			                'width' => $galleryConf['img_width'],
			                'height' => $galleryConf['img_height'],
			                'crop' => true,
			                'alt' => ! empty($img['alt']) ? $img['alt'] : $data['CaseStudy']['name']
			            ]);

		        ?>
	            		<li><?php echo $image; ?></li>
	        	<?php
					endforeach;
				?>
	        </ul>
	        <div class="ev-case-studies__view__gallery__thumbs">
		        <?php
		        	foreach($data['GalleryImage'] as $id => $img):
			            $thumb = $this->Img->resize($img, [
			                'width' => $galleryConf['thumb_width'],
			                'height' => $galleryConf['thumb_height'],
			                'crop' => true,
			                'alt' => $img['alt']
			            ]);
		        ?>
	            		<a data-slide-index="<?php echo $id; ?>"><?php echo $thumb; ?></a>
		        <?php
					endforeach;
				?>
	        </div>
	    </div>
    <?php
		endif;
	?>
	<div class="ev-case-studies__view__content">
		<?= $data['CaseStudy']['body'] ?>
	</div>
</div>
