# EvCaseStudies

EvCaseStudies is a relatively simple plugin that allows for case studies to be
displayed on a website. Each case study is assigned to a category, and as default
the plugin will show all active case studies in a paginated list.

The main index listing page will show a snippet of the case study, with a
'read more' link that'll take you through to the full case study page, which acts
pretty much the same as a standard content page.

Case studies also support a single 'featured' listing image, as well as a gallery.

You can also list case studies within categories.

There are two widgets provided inside this plugin:

 - Latest Case Studies
 - Categories

The latest case studies widget will list the case studies by the 'created'
date stamp in the database, and allows a $limit param to be provided, which as
default will be set to 3.

The categories widget lists all the case study categories, which when clicked
will take you to the complete category listing page.


## Installation

This is a composer plugin so from www/app just run composer as:-

    composer require evoluted/casestudies 2.1.* --prefer-source

To setup the database use the CakeDC Migrations plugin. To run the migrations
and setup the database run:-

    Console/cake Migrations.migration run all --plugin EvCaseStudies

Add the following to the plugin load array in 'app/Config/bootstrap.php':-

	'EvCaseStudies' => array(
		'bootstrap' => true,
		'routes' => true
	)

You will want to add an item to the admin menu for managing case studies:-

	/admin/ev_case_studies/casestudies/

To setup/override the plugin's default config create a new config file
'app/Config/Plugin/ev_case_studies.php'.

The following options are available:-

* page_id - The page id to load for meta data use on the case studies page.
* page_limit - Number of case studies to show per page
* snippet_length - The length of the case study snippet to show on the listing page.
* routes - Route sub array for routing incase of overwriting the controller.
* imageSlots - Control whether image slots are required in the plugin, passed in the same was as when assigning through EvCore (see example below)
* documentSlots - Control whether image slots are required in the plugin. Works in exactly the same way as you would find in EvCore and also the plugin imageSlots config
* hasTemplates - Choose whether to use the EvTemplate plugin

## Using EvCaseStudies

A simple listing page is accessible via /case-studies

This page simply lists the active case studies in a paginated format.

The template for this can be overwritten using the standard Cake plugin template
overriding by creating a file at:

	app/View/Plugin/EvCaseStudies/CaseStudies/index.ctp

The plugin also comes with a Component to be used for placing case studies on a
none plugin page, i.e. sidebar of homepage.

In your controller where you want the case studies to appear (i.e. getHomepageExtras
or AppController::beforeRender()) place the following code to load the case studies
and add to the template

	$this->CaseStudies = $this->Components->load('EvCaseStudies.CaseStudies');
	$this->set(
		'casestudies',
		$this->CaseStudies->caseStudyWidget()
	);

Then in your template call the following template code

	<?php if (isset($casestudies) && ! empty($casestudies)): ?>

		<?php foreach ($casestudies as $casestudies): ?>

			<?php echo $this->Element('EvCaseStudies.widget', array('item' => $casestudy)); ?>

		<?php endforeach; ?>

	<?php endif; ?>

Again, this element can be overwritten using the standard Cake plugin template
overriding:

	app/View/Plugin/EvCaseStudies/Elements/widget.ctp


### Image Slots

Image slots can be turned off an on through the plugin config file in the same format as they are used in EvCore, for example

	$config = [
		'EvCaseStudies' => [
		  ...
		  'imageSlots' => [
				'featured' => [
					'fields' => [
						'alt'
					],
					'slots' => 1
				],
				'gallery' => [
					'fields' => [
						'alt'
					],
					'slots' => -1
				],
			]
		]
	];

Passing through an empty array or `false` will prevent image slots from being used in the plugin

### Document Slots

Document slots work in the exact same was as image slots, for example

	$config = [
		'EvCaseStudies' => [
		  ...
		  'documentSlots' => -1
		]
	];

Passing through an empty array or `false` will prevent image slots from being used in the plugin

### Templates

Flag to specify whether the plugin takes advantage of EvTemplate functionality. Turned off, `false`, as default. To turn on simply switch the value to `true` in the plugin config file

### Extending Plugin

The usual rules apply, don't edit the plugin directly but override it from within
your own app.

### Future development

* Switch to option case study categories, rather than mandatory
