<?php

App::uses('EvCaseStudiesAppModel', 'EvCaseStudies.Model');
App::uses('String', 'Utility');

class CaseStudy extends EvCaseStudiesAppModel {

	public $actsAs = array(
		'Routable.Routable' => array(
			'alias' => 'case-studies/:displayField',
			'config' => 'EvCaseStudies'
		),
		'MetaData.Meta'
	);

	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'message' => 'Please add a name',
				'rule' => array('notBlank')
			),
		),
		'case_study_category_id' => array(
			'notBlank' => array(
				'message' => 'Please tag to a case study category',
				'rule' => array('notBlank')
			)
		)
	);

	public $belongsTo = array(
		'CaseStudyCategory' => array(
			'className' => 'EvCaseStudies.CaseStudyCategory'
		)
	);

/**
 * Setup the model
 */
	public function __construct($id = false, $table = null, $ds = null) {
		// assign imageSlots from the plugin config
		$imageSlots = Configure::read('EvCaseStudies.imageSlots');

		if (! empty($imageSlots)) {
			$this->imageSlots = $imageSlots;
		}

		// assign documentSlots from the plugin config
		$documentSlots = Configure::read('EvCaseStudies.documentSlots');

		if (! empty($documentSlots)) {
			$this->documentSlots = $documentSlots;
		}

		// include EvTemplates functionality, when required
		if (! empty(Configure::read('EvCaseStudies.hasTemplates'))) {
			$this->actsAs['EvTemplates.Template'] = [
				'formInject' => true
			];
		}

		parent::__construct($id, $table, $ds);
	}

	public function readForEdit($id, $query = array()) {
		$query['contain'][] = 'CaseStudyCategory';

		return parent::readForEdit($id, $query);
	}

	public function afterFind($results, $primary = false) {
		$results = parent::afterFind($results, $primary);
		$length = Configure::read('EvCaseStudies.snippet_length');

		$snippetConf = Configure::read('EvCaseStudies.snippet');

		if (! empty($results)) {
			foreach ($results as $k => $casestudy) {

				if (isset($casestudy['CaseStudy'])) {

					if (isset($casestudy['CaseStudy']['body']) && !empty($casestudy['CaseStudy']['body'])) {
						$snippet = strip_tags($casestudy['CaseStudy']['body']);

						$snippet = CakeText::truncate($snippet, $snippetConf['length'], array(
							'exact' => $snippetConf['exact'],
							'ellipsis' => $snippetConf['ellipsis']
						));

						$results[$k]['CaseStudy']['snippet'] = $snippet;
					}
				}

				if (! isset($casestudy['CaseStudy']['case_study_category_id']) || empty($casestudy['CaseStudy']['case_study_category_id'])) {

					$results[$k]['CaseStudy']['case_study_category_id'] = 0;
				}
			}
		}

		return $results;
	}

}
