<?php

App::uses('AppController', 'Controller');

class EvCaseStudiesAppController extends AppController {

	public $helpers = [
		'EvCaseStudies.CaseStudies'
	];

/**
 * Constructor.
 *
 * @param CakeRequest $Request Request object for this controller. Can be null for testing,
 *  but expect that features that use the request parameters will not work.
 * @param CakeResponse $Response Response object for this controller.
 * @return void
 */
	public function __construct(CakeRequest $Request, CakeResponse $Response) {
		parent::__construct($Request, $Response);
	}

	public function beforeFilter() {
		parent::beforeFilter();

		$this->CaseStudiesWidgets = $this->Components->load('EvCaseStudies.CaseStudiesWidgets');
	}

	public function widgetLatestCaseStudies($limit = 3) {
		$latestCaseStudies = $this->CaseStudiesWidgets->latestCaseStudies($limit);

		$view = new View($this, false);
		$view->loadHelper('Routable.Route');
		$view->set('latestCaseStudies', $latestCaseStudies);
		$output = $view->render('EvCaseStudies.Widgets/latest_case_studies', false);

		$this->set('caseStudiesPluginWidgetLatestCaseStudies', $output);
	}

	public function widgetCategories($limit = null) {
		$categories = $this->CaseStudiesWidgets->categories($limit);

		$view = new View($this, false);
		$view->loadHelper('Routable.Route');
		$view->set('categories', $categories);
		$output = $view->render('EvCaseStudies.Widgets/categories', false);

		$this->set('caseStudiesPluginWidgetCategories', $output);
	}

	/**
	 * Create a widget that filters by category
	 * @param  [integer] $limit The limit parameter for a find()
	 */
	public function widgetFilterByCategory($limit = null) {
		$categories = $this->CaseStudiesWidgets->categories($limit);

		$params = [];
		foreach ($this->request->params['named'] as $param => $value) {
			$params[$param] = $value;
		}
		$url = [
			'plugin' => $this->request->plugin,
			'controller' => $this->request->controller,
			'action' => $this->request->action
		];

		$route = array_merge($url, $params);

		$view = new View($this, false);
		$view->loadHelper('Routable.Route');
		$view->set('categories', $categories);
		$view->set('currentRoute', $route);
		$output = $view->render('EvCaseStudies.Widgets/filterByCategory', false);

		$this->set('caseStudiesPluginWidgetFilterByCategory', $output);
	}

/**
 * Create a widget that filters by date. Has a list of links based on years. Has an Older than link so case studies
 * older than the last displayed year can be seen. Also has a clear link that removed any date filtering.
 * @param  dateString $afterDate  Limit the date links only display case studies after this date
 * @param  dateString $beforeDate Limit the date links only display case studies before this date
 * @return String                 The html string for the widget
 */
	public function widgetFilterByDate($afterDate = null, $beforeDate = null, $maxDateLinks = 10) {
		$dates = $this->CaseStudiesWidgets->filterDates($afterDate, $beforeDate);

		$route = $this->_makeRoute();

		$view = new View($this, false);
		$view->loadHelper('Routable.Route');
		$view->set('maxDateLinks', $maxDateLinks);
		$view->set('dates', $dates);
		$view->set('currentRoute', $route);
		$output = $view->render('EvCaseStudies.Widgets/filterByDate', false);

		$this->set('case_studies_plugin_widget_filter_by_date', $output);
	}

/**
 * Make a route from named parameters
 *
 * @return array
 */
	protected function _makeRoute() {
		$params = [];
		foreach ($this->request->params['named'] as $param => $value) {
			if ($param === 'page') {
				continue;
			}
			$params[$param] = $value;
		}
		$url = [
			'plugin' => $this->request->plugin,
			'controller' => $this->request->controller,
			'action' => $this->request->action
		];

		$route = array_merge($url, $params);
		return $route;
	}
}
