<?php

App::uses('Component', 'Controller');

class CaseStudiesWidgetsComponent extends Component {

	private $__controller = null;

/**
 * Sets a reference to the calling controller from within the component.
 *
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);

		$this->__controller = $controller;
	}

/**
 * Returns data for the latest requested number of case studies
 *
 * @param int $limit The number of items to return
 * @return array Contains the latest $limit items
 */
	public function latestCaseStudies($limit = 3) {
		$CaseStudy = EvClassRegistry::init('EvCaseStudies.CaseStudy');

		return $CaseStudy->find('all', array(
			'conditions' => array(
				'CaseStudy.is_active' => 1
			),
			'order' => 'CaseStudy.created DESC',
			'limit' => $limit
		));
	}

/**
 * Returns list of Case Study Categories containing a count of how many
 * case studies belong to the category
 *
 * @param int $limit The number of categories to return
 * @return array Containing the categories data
 */
	public function categories($limit = null) {
		$CaseStudyCategory = EvClassRegistry::init('EvCaseStudies.CaseStudyCategory');
		$CaseStudy = EvClassRegistry::init('EvCaseStudies.CaseStudy');

		$params = array(
			'conditions' => array(
				'CaseStudyCategory.is_active' => 1
			),
			'order' => 'CaseStudyCategory.sequence ASC'
		);

		if (! empty($limit)) {
			$params['limit'] = $limit;
		}

		$categories = array(
			array(
				'CaseStudyCategory' => array(
					'id' => 0,
					'name' => 'Uncategorised'
				)
			)
		);

		$data = $CaseStudyCategory->find('all', $params);
		$categories = array_merge($categories, $data);

		foreach ($categories as $k => $category) {
			if ($category['CaseStudyCategory']['id'] == 0) {
				$category['CaseStudyCategory']['id'] = null;
			}

			$count = $CaseStudy->find('count', array(
				'conditions' => array(
					'CaseStudy.is_active' => 1,
					'CaseStudy.case_study_category_id' => $category['CaseStudyCategory']['id']
				)
			));

			if ($count > 0) {
				$categories[$k]['CaseStudyCategory']['count'] = $count;
			} else {
				unset($categories[$k]);
			}
		}

		return $categories;
	}

/**
 * Find the dates for the filterByDate widget and format them so they are nested inside the month and year.
 * @param  dateString $afterDate  Filter dates down to only be after this date
 * @param  dateString $beforeDate Filter dates down to only be before this date
 * @return array                  The array of dates in the correct format for the filterByDate widget.
 */
	public function filterDates($afterDate = null, $beforeDate = null) {
		$CaseStudy = EvClassRegistry::init('EvCaseStudies.CaseStudy');

		$dateFindParams = [
			'fields' => [
				'CaseStudy.id',
				'CaseStudy.published'
			],
			'conditions' => [
				'CaseStudy.is_active' => true,
				'CaseStudy.published IS NOT NULL'
			],
			'order' => 'CaseStudy.published DESC'
		];

		if ($afterDate !== null) {
			$dateFindParams['conditions'][]['CaseStudy.published >='] = $afterDate;
		}

		if ($beforeDate !== null) {
			$dateFindParams['conditions'][]['CaseStudy.published <='] = $beforeDate;
		}

		$caseStudies = $CaseStudy->find('all', $dateFindParams);

		$dates = [];
		//Format dates into year->month format
		foreach ($caseStudies as $index => $caseStudy) {
			$publishedDate = DateTime::createFromFormat('Y-m-d H:i:s', $caseStudy['CaseStudy']['published']);

			$publishedYear = $publishedDate->format('Y');
			$publishedMonth = $publishedDate->format('m');

			$dates[$publishedYear][$publishedMonth][] = $caseStudy;
		}

		return $dates;
	}
}
