<?php
App::uses('EvCaseStudiesAppController', 'EvCaseStudies.Controller');

class CaseStudyCategoriesController extends EvCaseStudiesAppController {

	public function beforeFilter() {
		$this->Auth->allow('view');

		return parent::beforeFilter();
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();
		unset($fields['body']);

		return $fields;
	}

	/**
	 * view
	 *
	 * Displays all case studies within a given category id
	 *
	 * @param  int $id ID of the case study category to show case studies for
	 */
	public function view($id) {
		$Model = $this->{$this->modelClass};

		// Fall back incase no page is found
		$this->set('title_for_layout', "Case Studies");

		if ($id == 0) {

			$category = array(
				'CaseStudyCategory' => array(
					'name' => 'Uncategorised'
				)
			);
			$categoryId = null;

		} else {

			$category = $Model->findById($id);
			$categoryId = $id;
		}
		$this->Meta->set($category);
		$this->set('category', $category);

		$this->paginate = array(
			'conditions' => array(
				'CaseStudy.is_active' => 1,
				'CaseStudy.case_study_category_id' => $categoryId
			),
			'order' => 'CaseStudy.sequence ASC',
			'contain' => array(
				'CaseStudyCategory',
				'FeaturedImage',
				'GalleryImage'
			),
			'limit' => Configure::read('EvCaseStudies.page_limit')
		);

		$this->loadModel('EvCaseStudies.CaseStudy');
		$this->set('data', $this->paginate('CaseStudy'));

		// call the widgets
		$this->widgetLatestCaseStudies();
		$this->widgetCategories();

		$this->view = 'EvCaseStudies.CaseStudyCategories/view';
	}
}
