# EvBulkDiscount

## Installation

Simply add EvBulkDiscount to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvBulkDiscount`.

There is no installer for this plugin, only zuul... i mean migrations.

## How it works

The bulk discount plugin works by using a behavior and `formInject` to add a bulk discount tab to the main model which then provides cloneable "Add New" functionality which allows you to enter the quantity needed and the percentage discount that will be given.

When used in the EvCommerce context, a listener is then setup to listen for basket add / update / delete events and then it processes the quantity of each item and applies any percentage discount needed.

## Setup

To setup, simply run the installer and attach the behavior to the model that wants to have Bulk Discount functionality.

	if (CakePlugin::loaded('EvBulkDiscount')) {
		$this->actsAs['EvBulkDiscount.BulkDiscounts'] = array(
			'formInject' => true
		);
	}
	
Then if used within basket / checkout the listeners are all setup to already listen for the correct events and process the basket accordingly.

If using in a custom situation, then some manual work will be needed to setup and process the discount. Manual work will be needed to total up the quantity and then get the correct price percentage to use.

Once you have the correct percentage discount to use and the original unit price you can then use the bundled library file to calculate and return the new unit price.

	App::uses('BulkDiscountLib', 'EvBulkDiscount.Lib');
	$newUnitPrice = BulkDiscountLib::calculateDiscount($originalUnitPrice, $percentDiscount);
	
 

