<?php

App::uses('AppHelper', 'View/Helper');
App::uses('BulkDiscountLib', 'EvBulkDiscount.Lib');


class BulkDiscountsHelper extends AppHelper {

	/**
	 * inject the tab into the form
	 *
	 */
	public function injectAdminForm() {
		// check the logged in user to prevent showing the form if they are not an admin
		echo $this->element(
			'form_tab',
			array(
				'title' => 'Bulk Discounts',
				'tabContent' => $this->element('EvBulkDiscount.manage/discountTab')
			)
		);
	}

	/**
	 * calculate the discount
	 * pass off to the lib
	 *
	 * @param 	float 	$unitPrice 		The current unitPrice
	 * @param 	float 	$percentage		The discount percentage
	 * @return 	float 	$newUnitPrice 	The updated unit price
	 */
	public function calculateDiscount($unitPrice, $percentage) {
		return BulkDiscountLib::calculateDiscount($unitPrice, $percentage);
	}

	/**
	 * Calculate the total amount of savings in a basket made from bulk discounts
	 * @param  array $basketItems     The list of items in the basket
	 * @param  array $originalPrices  The list of original prices read from the basket cookie
	 * @return int                    The total amount of savings made from bulk discounts.
	 */
	public function calculateBulkSavings($basketItems, $originalPrices) {
		$savings = 0;

		foreach ($basketItems as $basketItemId => $item) {
			//Check if an original price exists, if it doesn't then it hasn't had a bulk discount applied
			if (isset($originalPrices[$basketItemId])) {
				$originalUnitPrice = $originalPrices[$basketItemId];

				if ($item['unit_price'] != $originalUnitPrice['unit_price']) {
					//Item has been discounted
					$currentRowTotal = $item['unit_price'] * $item['quantity'];
					$originalRowTotal = $originalUnitPrice['unit_price'] * $item['quantity'];

					//If the basket plugin is loaded and it includes tax then we need to change consider the tax in the savings
					if (CakePlugin::loaded('EvBasket')) {
						if (Configure::read('EvBasket.siteIncludingTax')) {
							//Add the tax onto the rows
							$currentRowTotal = ($item['unit_price'] + $item['unit_tax']) * $item['quantity'];
							$originalRowTotal = ($originalUnitPrice['unit_price'] + $originalUnitPrice['unit_tax']) * $item['quantity'];
						}
					}

					$savingOnCurrentItem = $originalRowTotal - $currentRowTotal;
					$savings += $savingOnCurrentItem;
				}
			}
		}

		return $savings;
	}
}
