<?php

App::uses('AppBehavior', 'Model/Behavior');
App::uses('ArrayUtil', 'EvCore.Lib');

class BulkDiscountsBehavior extends AppBehavior {

	/**
	 * bind the inventory model to the model
	 *
	 */
	public function linkBulkDiscount(&$Model) {
		$Model->bindModel(
			array(
				'hasMany' => array(
					'BulkDiscount' => array(
						'className' => 'EvBulkDiscount.BulkDiscount',
						'foreignKey' => 'model_id',
						'conditions' => array(
							'BulkDiscount.model' => EvClassRegistry::getNameFromModel($Model)
						)
					)
				)
			),
			false
		);
	}

	/**
	 * Setup this behavior with the specified configuration settings.
	 *
	 * @param Model $model Model using this behavior
	 * @param array $config Configuration settings for $model
	 * @return void
	 */
	public function setup(Model $Model, $config = array()) {
		parent::setup($Model, $config);

		$this->linkBulkDiscount($Model);
	}

	/**
	 * process any options and validation into json for storage
	 *
	 * @param Model $model Model using this behavior
	 * @param array $options Options passed from Model::save().
	 * @return mixed False if the operation should abort. Any other result will continue.
	 * @see Model::save()
	 */
	public function beforeBeforeSave(&$Model, $data, $options = array()) {
		$this->linkBulkDiscount($Model);

		if (! empty($data['BulkDiscount'])) {
			$modelAlias = EvClassRegistry::getNameFromModel($Model);

			foreach ($data['BulkDiscount'] as $key => $discount) {
				$data['BulkDiscount'][$key]['model'] = $modelAlias;
			}
		}

		return $data;
	}

	/**
	 * Save the discounts
	 *
	 * @param Model $model Model using this behavior
	 * @param bool $created True if this save created a new record
	 * @param array $options Options passed from Model::save().
	 * @return bool
	 * @see Model::save()
	 */
	public function afterSave(Model $Model, $created, $options = array()) {
		$return = parent::afterSave($Model, $created, $options);
		$result = true;

		$BulkDiscount = EvClassRegistry::init('EvBulkDiscount.BulkDiscount');

		// process any custom field deletions
		if (! empty($Model->data[$Model->alias]['BulkDiscounts']['toDelete'])) {

			$ids = explode(',', $Model->data[$Model->alias]['BulkDiscounts']['toDelete']);
			$ids = ArrayUtil::clearArray($ids);

			$BulkDiscount->deleteAll(
				array(
					'BulkDiscount.id' => $ids
				),
				true,
				true
			);
		}

		return $return;
	}

	/**
	 * beforeFind can be used to cancel find operations, or modify the query that will be executed.
	 * By returning null/false you can abort a find. By returning an array you can modify/replace the query
	 * that is going to be run.
	 *
	 * @param Model $model Model using this behavior
	 * @param array $query Data used to execute this query, i.e. conditions, order, etc.
	 * @return bool|array False or null will abort the operation. You can return an array to replace the
	 *   $query that will be eventually run.
	 */
	public function beforeFind(Model $Model, $query) {
		$this->linkBulkDiscount($Model);

		$query['contain']['BulkDiscount'] = array(
			'order' => 'BulkDiscount.quantity ASC'
		);

		return $query;
	}
}
