<?php

App::uses('CakeEventManager', 'Event');

class EvBulkDiscountEvents {

	protected $_plugin = 'EvBulkDiscount';

	protected $_path = 'Lib/Event';

	protected $_events = [
		'BulkDiscountBasketListener' => [
			'requiresPlugin' => 'EvBasket',
		],
		'BulkDiscountClearCookieListener' => [
			'requiresPlugin' => 'EvBasket',
		],
		'BulkDiscountCurrencyChangeListener',
	];

/**
 * Construct the events.
 */
	public function __construct() {
		$this->_attachEvents();
	}

/**
 * Attach the current events to the CakeEventManager.
 *
 * @return void.
 */
	protected function _attachEvents() {
		foreach ($this->_events as $event => $eventConditions) {
			if (!is_array($eventConditions)) {
				$event = $eventConditions;
				$eventConditions = [];
			}

			if (!empty($eventConditions['requiresPlugin']) && !CakePlugin::loaded($eventConditions['requiresPlugin'])) {
				continue;
			}

			//Check for extended event
			$className = $this->_plugin . $event;
			App::uses($className, $this->_path . DS . $this->_plugin);

			if (class_exists($className)) {
				CakeEventManager::instance()->attach(
					new $className
				);
				continue;
			}

			//Attach plugin event
			$className = $event;
			App::uses($className, $this->_plugin . '.' . $this->_path);
			if (class_exists($className)) {
				CakeEventManager::instance()->attach(
					new $className
				);
			}
		}
	}

}

new EvBulkDiscountEvents();
