<?php

App::uses('CakeEventListener', 'Event');

class BulkDiscountClearCookieListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCheckout.Controller.Order.success' => 'clearCookie'
		);
	}

	/**
	 * clear the cookie
	 *
	 * @param 	CakeEvent
	 */
	public function clearCookie(CakeEvent $Event) {
		if (! CakePlugin::loaded('EvBasket')) {
			return false;
		}

		// Event Subject sghould be controller
		$EventSubject = $Event->subject();

		// try to load the discount cookie
		if (empty($EventSubject->BasketCookie)) {
			$EventSubject->BasketCookie = $EventSubject->loadComponent('EvBasket.BasketCookie');
		}

		$EventSubject->BasketCookie->delete('originalUnitPrices');

		return true;
	}

}
