# EvBreadcrumb

Simple breadcrumb component and view element for rendering breadcrumb trails.

Default template has been setup to conform with the frontend snippets breadcrumb example.


## Install

If you're not using `CakePlugin::loadAll()` add the following in `app/Config/bootstrap.php`:

	CakePlugin::load('EvBreadcrumb');

Next you need to load the component, this can be done within `app/Controller/AppController.php` by using the following code, if the beforeFilter method already exists, just copy the Component load line:

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Breadcrumb = $this->Components->load('EvBreadcrumb.Breadcrumb');
	}

### Configs

You can set some of the default values here on load if needed, by adding a second array to the `load` method. This can be used to add a starting link (e.g. the home link).

Available options are:

* `crumbs` - This should be a multi-dimensional array with the sub-array containing `text` element and an `url` element.
* `backLink` - This should be an array containing `text` element and `url` element. This is used to float right of the breadcrumb trails for a "Back to XXX" style link

n.b. `url` element is passed to `Html->link()` so can be either a string or Routing Array.

Full Example:

		$this->Breadcrumb = $this->Components->load(
			'EvBreadcrumb.Breadcrumb',
			array(
				'crumbs' => array(
					array(
						'text' => 'Home',
						'url' => array(
							'plugin' => false,
							'controller' => 'ev_core_pages',
							'action' => 'view',
							1
						),
						'options' => array(
							'escape' => false
						)
					)
				),
				'backLink' => array(
					'text' => 'Back to Homepage',
					'url' => '/',
					'options' => array(
						'escape' => false
					)
				)
			)
		);


## Usage

### Main Breadcrumb Links

Assuming the component has been loaded as above you can use the following methods to add links to the breadcrumb

	$this->Breadcrumb->addCrumb(
		'Link Text',
		array(
			'controller' => 'pages',
			'action' => 'view',
			1
		),
		array(
			'escape' => false
		)
	);

For the last item in a breadcrumb, just simply omit the second parameter with the above call.

	$this->Breadcrumb->addCrumb('Link Text');

### Back Link

If you wish to add a back link on the fly use the `backLink` Method.

	$this->Breadcrumb->backLink(
		'Back to Categories',
		array(
			'controller' => 'categories',
			'action' => 'view',
			1
		)
	);


## Retrieving Data

To retrieve current data you can use the following methods:-

	$links = $this->Breadcrumb->crumbs(); // Array of all the links currently added
	$backLink = $this->Breadcrumb->backLink(); // Array containing the back link info

## Clear Links

Should you need to clear the link array, you can do so with the following method.

	$this->Breadcrumb->clearCrumbs();

## Helper

The plugin comes with a helper to simplify building the markup for Views. Include it like:-

	public $helpers = array('EvBreadcrumb.Breadcrumb');

You can set the separator when initiating the helper like this:-

    public $helpers = array(
		'EvBreadcrumb.Breadcrumb' => array(
			'separator' => '&raquo;'
		)
	);

You can use the helper to output the breadcrumb like this:-

	<ul><?= $this->Breadcrumb->crumbs($breadcrumbs) ?></ul>

And similarly for the back link:-

	<?= $this->Breadcrumb->backLink($breadcrumbs) ?>

## Template

Assuming the HTML has been done to correspond with the Breadcrumb snippet in the frontend-snippets repo, all that you need to do is call the element (and include the helper described above).

	<?= $this->element('EvBreadcrumb.breadcrumb'); ?>

If changes need to occur, the template can be overwritten using the standard plugin template overriding methods.

## Schema
A simple template that uses the breadcrumb functionality and adds the correct schema via an element. See: `https://schema.org/BreadcrumbList`

	<?= $this->element('EvBreadcrumb.schema'); ?>
