<?php

App::uses('AppHelper', 'View/Helper');

class BreadcrumbHelper extends AppHelper {

	public $helpers = array('Html');

	public $settings = array(
		'crumbsWrapTag' => null,
		'crumbsWrapAttributes' => array(),
		'crumbWrapTag' => 'li',
		'crumbWrapAttributes' => array(),
		'separator' => '<span class="breadcrumbs__sep"><i class="fa fa-angle-right"></i></span>'
	);

	/**
	 * Returns the back link if set.
	 * @param  array $breadcrumbs Full breadcrumbs variable set by the plugin
	 * @return string|void        Back link
	 */
	public function backLink($breadcrumbs) {
		if (!empty($breadcrumbs['backLink']['text']) && !empty($breadcrumbs['backLink']['url'])) {
			return $this->Html->link(
				$breadcrumbs['backLink']['text'],
				$breadcrumbs['backLink']['url'],
				!empty($breadcrumbs['backLink']['options']) ? $breadcrumbs['backLink']['options'] : array()
			);
		}
		return;
	}

/**
 * Returns the breadcrumb.
 *
 * @param array $breadcrumbs Full breadcrumbs variable set by the plugin.
 * @return string|void Fully marked up breadcrumb
 */
	public function crumbs($breadcrumbs) {
		$crumbs = array();

		foreach ($breadcrumbs['crumbs'] as $crumbIndex => $crumb) {
			$crumb = $this->_modifyCrumb(
				[
					'index' => $crumbIndex,
					'crumb' => $crumb,
					'wrapTag' => $this->settings['crumbWrapTag'],
					'wrapAttributes' => $this->settings['crumbWrapAttributes']
				]
			);

			$crumbs[] = $this->Html->tag(
				$crumb['wrapTag'],
				$this->crumb($crumb['crumb']),
				$crumb['wrapAttributes']
			);
		}

		if (!empty($this->settings['crumbsWrapTag'])) {
			return $this->Html->tag(
				$this->settings['crumbsWrapTag'],
				implode($this->separator(), $crumbs),
				$this->settings['crumbsWrapAttributes']
			);
		} else {
			return implode($this->separator(), $crumbs);
		}
	}

/**
 * Modify a crumb before it is added to the breadcrumbs.
 *
 * @param array $crumbData Array containing the crumb index, crumb and wrapTag info.
 * @return array An array returning the data to create the crumb tag. In the structure:
 *               'crumb' - array - The data of the crumb (text, url, link attributes),
 *               'wrapTag' - string - The tag to wrap the crumb in,
 *               'wrapAttributes' - array - Tag attributes to apply to the wrapping tag.
 */
	protected function _modifyCrumb($crumbData) {
		return [
			'crumb' => $crumbData['crumb'],
			'wrapTag' => $crumbData['wrapTag'],
			'wrapAttributes' => $crumbData['wrapAttributes'],
		];
	}

	/**
	 * Returns a breadcrumb.
	 * @param  array $breadcrumbs Breadcrumb array
	 * @return string|void
	 */
	public function crumb($crumb) {
		if (!empty($crumb['url'])) {
			return $this->Html->link(
				$crumb['text'],
				$crumb['url'],
				!empty($crumb['options']) ? $crumb['options'] : array()
			);
		} else {
			$crumbText = $crumb['text'];

			if (!isset($crumb['options']['escape']) || $crumb['options']['escape'] === true) {
				$crumbText = h($crumbText);
			}

			return $crumbText;
		}
	}

	/**
	 * Returns the separator.
	 * @return string Separator
	 */
	public function separator() {
		return $this->settings['separator'];
	}

}
