# Version 2.2 to 2.3

When no url is provided for a breadcrumb, the breadcrumb would just be displayed as text. This text wasn't escaped by default. The BreadcrumbHelper has been updated so that breadcrumbs are escaped by default (including those with urls). Breadcrumbs that have had html injected into them will need to have their text values modified so that their values are escaped and the Breadcrumb escape option is set to false. See below for example on what needs to be changed.

## Using the component

Before:
```
$this->Breadcrumb->addCrumb($breadcrumbText . '<i class="fa fa-chevron-right">');
```

After:
```
$this->Breadcrumb->addCrumb(
	h($breadcrumbText) . '<i class="fa fa-chevron-right">',
	null,
	[
		'escape' => false,
	]
);
```

## Using the helper

Before:
```
public function crumb($crumb) {
	if (empty($crumb['url'])) {
		$crumb['text'] .= '<i class="fa fa-chevron-right">';
	}

	return parent::crumb($crumb);
}
```

After:
```
public function crumb($crumb) {
	if (empty($crumb['url'])) {
		$crumb['text'] = h($crumb['text']) . <i class="fa fa-chevron-right">';
		$crumb['options']['escape'] = false;
	}

	return parent::crumb($crumb);
}
```
