<?php

App::uses('AppComponent', 'Controller/Component');

class BreadcrumbComponent extends Component {

	/**
	 * array containing the crumbs we've added
	 *
	 * @var array
	 */
	public $crumbs = array(
		array(
			'text' => 'Home',
			'url' => '/'
		)
	);

	/**
	 * array containing the text / link for a floating right item (usually back link)(
	 *
	 * @var array
	 */
	public $backLink = array();

	/**
	 * auto add a back link if none is added
	 *
	 * @var bool
	 */
	public $autoBackLink = true;

	/**
	 * back link prefix text for auto generated back links
	 *
	 * @var string
	 */
	public $backLinkPrefix = 'Back to ';

	/**
	 * add a breadcrumb
	 *
	 * @param   string              The crumb text to display
	 * @param   array|string|null   Optional: The actual link or route array.
	 * @param   array               Optional: Link options, incase escape => false type info needs passing
	 * @return  void
	 */
	public function addCrumb($text = null, $url = null, $options = array()) {
		if (!isset($options['escape'])) {
			$options['escape'] = true;
		}

		$this->crumbs[] = array(
			'text' => $text,
			'url' => $url,
			'options' => $options
		);

		return;
	}

	/**
	 * return the main breadcrumb crumbs
	 *
	 * @return  array  items will be returned
	 */
	public function crumbs() {
		return $this->crumbs;
	}

	/**
	 * clear all the crumbs.
	 * Just sets back to empty array
	 */
	public function clearCrumbs() {
		$this->crumbs = array();
	}

	/**
	 * add or return the back link
	 *
	 * @param   string|null         Optional: The link text to display
	 * @param   array|string|null   Optional: The actual link or route array.
	 * @param   array               Optional: Link options, incase escape => false type info needs passing
	 * @return  array               If both items are null, items will be returned
	 */
	public function backLink($text = null, $url = null, $options = array()) {
		if (is_null($text)) {
			return $this->backLink;
		}

		$this->backLink = array(
			'text' => $text,
			'url' => $url,
			'options' => $options
		);
	}

	/**
	 * Before Render callback. If we've not got the controller yet
	 * set it's object and then assign all our vars to template
	 *
	 * Called before the Controller::beforeRender(), and before
	 * the view class is loaded, and before Controller::render()
	 *
	 * @param Controller $controller Controller with components to beforeRender
	 * @return void
	 * @link http://book.cakephp.org/2.0/en/controllers/components.html#Component::beforeRender
	 */
	public function beforeRender(Controller $controller) {
		if (is_null($this->_controller)) {
			$this->_controller = $controller;
		}

		if (count($this->crumbs) > 1 && $this->autoBackLink === true && empty($this->backLink)) {
			end($this->crumbs);
			$this->backLink = prev($this->crumbs);
			$this->backLink['text'] = $this->backLinkPrefix . $this->backLink['text'];
		}

		$this->_setToView();
	}

	/**
	 * build an array and assign data to view
	 *
	 */
	protected function _setToView() {
		$this->_controller->set(
			'breadcrumbs',
			array(
				'crumbs' => $this->crumbs,
				'backLink' => $this->backLink
			)
		);
	}
}
