<?php
// define blog post url
$blogPostUrl = $this->Route->getItemRoute('EvBlog', 'BlogPost');
$blogPostUrl['action'] = 'view';
$blogPostUrl[] = $post['BlogPost']['id'];

$url = Router::url($blogPostUrl, true) . '#comment-' . $comment_id;

$commentAdminUrl = $this->Route->getItemRoute('EvBlog', 'BlogComment');
$commentAdminUrl['admin'] = true;
$commentAdminUrl['action'] = 'admin_edit';
$commentAdminUrl[] = $comment_id;

$url = Router::url($blogPostUrl, true) . '#comment-' . $comment_id;
$adminUrl = Router::url($commentAdminUrl, true);
?>

<p>A new comment has been posted on your website. A copy of the comment can be found below:</p>
<hr>
<table class="table" width="100%" border="0" cellspacing="2" cellpadding="0">
<?php if ($moderated): ?>
    <thead>
        <tr>
            <th colspan="2" align="center">
                <a href="<?php echo $adminUrl; ?>" style="display:block;background:#c00;color:#fff;padding: 5px;">
                    This comment is not yet published. Click here to manage the comment.
                </a>
            </th>
        </tr>
    </thead>
<?php endif; ?>
    <tbody>
        <tr>
            <td><strong>Author:</strong></td>
            <td><?php echo $comment['BlogComment']['author']; ?></td>
        </tr>
        <tr>
            <td><strong>Email:</strong></td>
            <td>
                <a href="mailto:<?php echo $comment['BlogComment']['email']; ?>">
                    <?php echo nl2br($comment['BlogComment']['email']); ?>
                </a>
            </td>
        </tr>
        <tr>
            <td><strong>Comment:</strong></td>
            <td><?php echo $comment['BlogComment']['comment']; ?></td>
        </tr>
        <?php if (!$moderated): ?>
        <tr>
            <td colspan="2" align="center">
                <a href="<?php echo $url; ?>">Click here</a> to view the comment or
                <a href="<?php echo $adminUrl; ?>">Click Here</a> to manage the comment.
            </td>
        </tr>
        <?php endif; ?>
    </tbody>
</table>
<hr>
