<?php
	// define blog post url
	$blogPostUrl = $this->Route->getItemRoute('EvBlog', 'BlogPost');
	$blogPostUrl['action'] = 'view';
	$blogPostUrl[] = $blog['BlogPost']['id'];
?>
<div class="ev-blog__list__item">
	<div class="row">
		<div class="col-xs-12 col-sm-4 col-xs-3">
			<?php
				$imgAlt = (! empty($blog['ListingImage'][0]['alt'])) ? $blog['ListingImage'][0]['alt'] : $blog['BlogPost']['name'];
				$image = ! empty($blog['ListingImage'][0]) ? $blog['ListingImage'][0] : [];
				echo $this->Img->resize($image, array(
					'width' => 200,
					'height' => 145,
					'crop' => true
				),
				array(
					'alt' => $imgAlt,
					'url' => $blogPostUrl
				));
			?>
		</div>
		<div class="col-xs-12 col-sm-8 col-xs-9">
			<h2 class="ev-blog__list__item__title">
				<?php echo $this->Html->link($blog['BlogPost']['name'], $blogPostUrl); ?>
			</h2>
			<div class="ev-blog__list__item__date">
				<?php echo $this->Time->format("jS F Y", $blog['BlogPost']['posted']); ?>
			</div>

			<div class="ev-blog__list__item__snippet">
				<?php
					echo stripslashes($blog['BlogPost']['snippet']);
					echo $this->Html->link('Read More',
						$blogPostUrl,
						array(
							'class' => 'ev-blog__list__item__snippet__read-more'
						)
					);
				?>
			</div>

			<ul class="ev-blog__list__meta">
				<li class="ev-blog__list__meta__label">Author</li>
				<li class="ev-blog__list__meta__value"><?php echo $blog['BlogPost']['author']; ?></li>

				<?php if (Configure::read('EvBlog.disable_comments') != true): ?>
					<li class="ev-blog__list__meta__label">
						<?php
							$commentUrl = Router::url($blogPostUrl) . '#blog-comments';
							echo $this->Html->link(
								'comments',
								$commentUrl,
								array(
									'escape' => false
								)
							);
						?>
					</li>
					<li class="ev-blog__list__meta__label">
						<?php
							echo $this->Html->link(
								(isset($blog['BlogComment'])) ? count($blog['BlogComment']) : '0',
								$commentUrl,
								array(
									'escape' => false
								)
							);
						?>
					</li>
				<?php endif; ?>

				<?php
					if (! empty($blog['BlogCategory'])):
				?>
						<li class="ev-blog__list__meta__label">
							Posted in
						</li>
						<li class="ev-blog__list__meta__value">
							<?php
								// single blog category
								if (! empty($blog['BlogCategory']['id'])):
									$blogCategoryUrl = $this->Route->getItemRoute('EvBlog', 'BlogCategory');
									$blogCategoryUrl['action'] = 'view';

									if (isset($blog['BlogCategory']['name']) && ! empty($blog['BlogCategory']['name'])):
										$blogCategoryUrl[] = $blog['BlogCategory']['id'];
										$blogCategoryName = $blog['BlogCategory']['name'];
									else:
										$blogCategoryUrl[] = 0;
										$blogCategoryName = 'Uncategorised';
									endif;

									echo $this->Html->link($blogCategoryName, $blogCategoryUrl);
								endif;

								// multiple blog categories
								if (! empty($blog['BlogCategory'][0])):
									$blogCategoryLinks = '';
									$i = 1;
									foreach ($blog['BlogCategory'] as $item):
										$blogCategoryUrl = $this->Route->getItemRoute('EvBlog', 'BlogCategory');
										$blogCategoryUrl['action'] = 'view';

										if (isset($item['name']) && ! empty($item['name'])):
											$blogCategoryUrl[] = $item['id'];
											$blogCategoryName = $item['name'];
										else:
											$blogCategoryUrl[] = 0;
											$blogCategoryName = 'Uncategorised';
										endif;

										$blogCategoryLinks .= $this->Html->link($blogCategoryName, $blogCategoryUrl);

										if ($i < count($blog['BlogCategory'])):
											$blogCategoryLinks .= ', ';
										endif;

										$i++;
									endforeach;

									echo $blogCategoryLinks;
								endif;
							?>
						</li>
				<?php
					endif;
				?>
			</ul>
		</div>
	</div>
</div>
