<?php
App::uses('EvBlogAppModel', 'EvBlog.Model');

class BlogComment extends EvBlogAppModel
{
	public $displayField = 'author';

	public $belongsTo = array(
		'BlogPost' => array(
			'className' => 'EvBlog.BlogPost'
		)
	);

	public $validate = array(
		'blog_post_id' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please tag to a blog post'
			),
		),
		'author' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please add an author'
			),
		),
		'comment' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please add a comment'
			),
		)
	);

}
