<?php

class EvBlogAppController extends AppController {

	public $helpers = array(
		'EvBlog.Gravatar'
	);

	public $disableTags = false;

	public function beforeFilter() {
		parent::beforeFilter();

		// update the $disableAuthor value based on the plugin config
		$this->disablePostAuthor = Configure::read('EvBlog.disable_post_author');

		// update the $disableTags value based on the plugin config
		$this->disableTags = Configure::read('EvBlog.disable_tags');

		// update the $disableCategories value based on the plugin config
		$this->disableCategories = Configure::read('EvBlog.disable_categories');

		$this->BlogWidgets = $this->loadComponent('EvBlog.BlogWidgets');
	}

/**
 * Returns list of the latest active blog posts
 *
 * @param int $limit The total number of items to return
 * @return void
 */
	public function widgetLatestPosts($limit = 3) {
		$latestPosts = $this->BlogWidgets->latestPosts($limit);

		$view = new View($this, false);
		$view->loadHelper('Routable.Route');
		$view->set('latestPosts', $latestPosts);
		$output = $view->render('EvBlog.Widgets/latest_posts', false);

		// todo: to be deprecated in a later major version
		$this->set('blogplugin_widget_latestposts', $output);

		// option to match coding standards
		$this->set('evBlogWidgetLatestposts', $output);
	}

/**
 * Returns list of blog categories and a tally of active posts
 *
 * @param int $limit The total number of items to return
 * @return void
 */
	public function widgetCategories($limit = null) {
		$categories = $this->BlogWidgets->categories($limit);

		$view = new View($this, false);
		$view->loadHelper('Routable.Route');
		$view->set('categories', $categories);
		$output = $view->render('EvBlog.Widgets/categories', false);

		// todo: to be deprecated in a later major version
		$this->set('blogplugin_widget_categories', $output);

		// option to match coding standards
		$this->set('evBlogWidgetCategories', $output);
	}

/**
 * Returns list of archive dates and a tally of active posts
 *
 * @param int $limit The total number of items to return
 * @return void
 */
	public function widgetArchives($limit = 12) {
		$dates = $this->BlogWidgets->archives($limit);

		$view = new View($this, false);
		$view->loadHelper('Routable.Route');
		$view->set('dates', $dates);
		$output = $view->render('EvBlog.Widgets/archives', false);

		// todo: to be deprecated in a later major version
		$this->set('blogplugin_widget_archives', $output);

		// option to match coding standards
		$this->set('evBlogWidgetArchives', $output);
	}

}
