<?php

$config = array(
	'EvBlog' => array(
		'page_id' => null, //Set a page ID here to add content to the top of the blog index page
		'use_page_template' => true, // Should the blog listing page use the template set on the above page?
		'snippet_length' => 85, // number of characters to show in the snippet
		'enable_hide_from_search_engines' => false,
		'listing_limit' => 10, // number of posts to show on the blog listing
		'rss_limit' => 20, // number of posts to show on the blog rss listing
		'disable_comments' => false,
		'disable_tags' => false,
		'disable_post_author' => false,
		'disable_categories' => false,
		'disable_category_count' => false,
		'disable_blog_widgets' => false,
		'enable_inline_images' => false,
		'route' => array(
			'BlogPost' => array(
				'controller' => 'ev_blog.blog_posts', // defined as plugin dot notation as plugin var is used for model references
				'action' => 'view',
				'plugin' => 'ev_blog' // used for model references
			),
			'BlogCategory' => array(
				'controller' => 'ev_blog.blog_categories', // defined as plugin dot notation as plugin var is used for model references
				'action' => 'view',
				'plugin' => 'ev_blog' // used for model references
			),
			'BlogTag' => array(
				'controller' => 'ev_blog.blog_tags', // defined as plugin dot notation as plugin var is used for model references
				'action' => 'view',
				'plugin' => 'ev_blog' // used for model references
			),
			'BlogComment' => array(
				'controller' => 'ev_blog.blog_comments', // defined as plugin dot notation as plugin var is used for model references
				'action' => 'view',
				'plugin' => 'ev_blog' // used for model references
			),
		)
	)
);
