<?php
App::uses('EvBlogAppModel', 'EvBlog.Model');

class BlogComment extends EvBlogAppModel
{
	public $displayField = 'author';

	public $belongsTo = array(
		'BlogPost' => array(
			'className' => 'EvBlog.BlogPost'
		)
	);

	public $validate = array(
		'blog_post_id' => array(
			'notBlank' => array(
				'rule' => array('notBlank')
			),
		),
		'author' => array(
			'notBlank' => array(
				'rule' => array('notBlank')
			),
		),
		'comment' => array(
			'notBlank' => array(
				'rule' => array('notBlank')
			),
		)
	);

}
