<?php
class HabtmChangesForCategories extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'habtm_changes_for_categories';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'drop_field' => array(
				'blog_blog_posts' => array('blog_category_id', 'indexes' => array('fk_blog_blog_posts_blog_blog_category_idx')),
			),
			'create_table' => array(
				'blog_categories_blog_posts' => array(
					'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'unsigned' => true, 'key' => 'primary'),
					'blog_post_id' => array('type' => 'integer', 'null' => true, 'default' => '0', 'unsigned' => false),
					'blog_category_id' => array('type' => 'integer', 'null' => true, 'default' => '0', 'unsigned' => false),
					'indexes' => array(
						'PRIMARY' => array('column' => 'id', 'unique' => 1),
					),
					'tableParameters' => array('charset' => 'utf8', 'collate' => 'utf8_general_ci', 'engine' => 'InnoDB'),
				),
			),
		),
		'down' => array(
			'create_field' => array(
				'blog_blog_posts' => array(
					'blog_category_id' => array('type' => 'integer', 'null' => true, 'default' => null, 'unsigned' => false, 'key' => 'index'),
					'indexes' => array(
						'fk_blog_blog_posts_blog_blog_category_idx' => array('column' => 'blog_category_id', 'unique' => 0),
					),
				),
			),
			'drop_table' => array(
				'blog_categories_blog_posts'
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
