<div class="container-fluid">
    <div class="row">
        <div class="col-xs-12 col-sm-8">
            <div class="ev-blog__post">

                <div class="ev-blog__post__published">
                    <?php echo $this->Time->format("jS F Y", $data['BlogPost']['posted']); ?>
                </div>

                <h1><?php echo $data['BlogPost']['name']; ?></h1>

                <?php echo $data['BlogPost']['body']; ?>

                <?php if (isset($data['BlogTag']) && ! empty($data['BlogTag'])): ?>
                    <p class="ev-blog__post__tags">
                        <span>Tags:</span>
                        <?php
                        $tags = array();

                        foreach ($data['BlogTag'] as $tag) {

                            $tagUrl = RouterUtil::getItemRoute('EvBlog', 'BlogTag');
                            $tagUrl[] = $tag['tag'];

                            $tags[] = $this->Html->link($tag['tag'], $tagUrl);
                        }

                        echo implode(', ', $tags);
                        ?>
                    </p>
                <?php endif; ?>

                <div class="ev-blog__comments">
                    <?php $comment_count = count($data['BlogComment']); ?>

                    <a name="blog-comments"></a>

                    <h2>
                        <?php
                        if ($comment_count > 1) {
                            echo $comment_count . ' Comments';
                        } elseif ($comment_count == 1) {
                            echo '1 Comment';
                        } else {
                            echo 'No Comments';
                        }
                        ?>
                    </h2>

                    <?php if ($comment_count > 0): ?>

                        <div class="ev-blog__comments__container">
                            <?php foreach ($data['BlogComment'] as $comment): ?>

                                <div class="ev-blog__comments__comment">
                                    <a name="comment-<?php echo $comment['id']; ?>"></a>

                                    <div class="ev-blog__comments__comment__image">
                                        <?php
                                        echo $this->Gravatar->get_gravatar(
                                            $comment['email'],
                                            58,
                                            'mm',
                                            'g',
                                            true,
                                            array(
                                                'alt' => $comment['author'] . ' Gravatar'
                                            )
                                        );
                                        ?>
                                    </div>

                                    <div class="ev-blog__comments__comment__body">
                                        <?php
                                        echo '<span class="ev-blog__comments__comment__author">' . $comment['author'] . '</h2>';
                                        echo '<span class="ev-blog__comments__comment__published">' . $this->Time->format('F jS, Y \a\t H:i', $comment['created']) . '</h4>';
                                        echo $comment['comment'];
                                        ?>
                                    </div>

                                </div>

                            <?php endforeach; ?>
                        </div>

                    <?php else: ?>
                        <p>Be the first to comment!</p>
                    <?php endif; ?>

                    <?php echo $this->Element('comments-form'); ?>
                </div>
            </div>
        </div>

        <div class="col-xs-12 col-sm-4">
            <div class="ev-blog__sidebar">
                <?php
                    echo $this->Element('EvBlog.sidebar');
                ?>
            </div>
        </div>
    </div>
</div>
