<?php
// define blog post url
$blogPostUrl = $this->Route->getItemRoute('EvBlog', 'BlogPost');
$blogPostUrl['action'] = 'view';
$blogPostUrl[] = $blog['BlogPost']['id'];
?>
<div class="ev-blog__post__listing">
    <div class="row">
        <div class="col-xs-12 col-sm-4 col-xs-3">
            <?php
            if (! empty($blog['ListingImage'])):

                $img_path = '../' . $blog['ListingImage']['0']['filepath'];
                $img_alt = (! empty($blog['ListingImage']['0']['alt'])) ? $blog['ListingImage']['0']['alt'] : $blog['BlogPost']['name'];

            else:

                $img_path = '..' . DS . 'img' . DS . 'no-image.png';
                $img_alt = $blog['BlogPost']['name'];

            endif;

            $image = $this->Image->resize($img_path, array(
                'width' => 200,
                'height' => 145,
                'crop' => true,
                'alt' => $img_alt
            ));

            echo $this->Html->link($image, $blogPostUrl, array('escape' => false));
            ?>
        </div>
        <div class="col-xs-12 col-sm-8 col-xs-9">
            <h2 class="ev-blog__post__listing__title">
                <?php echo $this->Html->link($blog['BlogPost']['name'], $blogPostUrl); ?>
            </h2>
            <div class="ev-blog__post__listing__date">
                <?php echo $this->Time->format("jS F Y", $blog['BlogPost']['posted']); ?>
            </div>

            <div class="ev-blog__post__listing__snippet">
                <?php
                echo stripslashes($blog['BlogPost']['snippet']);
                echo $this->Html->link('Read More', array(
                    'plugin' => 'ev_blog',
                    'controller' => 'blog_posts',
                    'action' => 'view',
                    $blog['BlogPost']['id']
                ));
                ?>
            </div>

            <ul class="ev-blog__listing__meta">

                <li class="ev-blog__listing__meta__author__label">Author</li>
                <li class="ev-blog__listing__meta__author__value"><?php echo $blog['BlogPost']['author']; ?></li>

                <li class="ev-blog__listing__meta__comments__label">
                    <?php
                    $commentUrl = Router::url($blogPostUrl) . '#blog-comments';

                    echo $this->Html->link(
                        'comments',
                        $commentUrl,
                        array(
                            'escape' => false
                        )
                    );
                    ?>
                </li>
                <li class="ev-blog__listing__meta__comments__label">
                    <?php
                    echo $this->Html->link(
                        (isset($blog['BlogComment'])) ? count($blog['BlogComment']) : '0',
                        $commentUrl,
                        array(
                            'escape' => false
                        )
                    );
                    ?>
                </li>

                <li class="ev-blog__listing__meta__category_label">Category</li>
                <li class="ev-blog__listing__meta__category__value">
                    <?php
                    if (isset($blog['BlogCategory']['name']) && ! empty($blog['BlogCategory']['name'])):
                        $blogCategoryUrl = $this->Route->getItemRoute('EvBlog', 'BlogCategory');
                        $blogCategoryUrl['action'] = 'view';
                        $blogCategoryUrl[] = $blog['BlogCategory']['id'];

                        echo $this->Html->link(
                            $blog['BlogCategory']['name'],
                            $blogCategoryUrl
                        );
                    else:
                        $blogCategoryUrl = $this->Route->getItemRoute('EvBlog', 'BlogCategory');
                        $blogCategoryUrl['action'] = 'view';
                        $blogCategoryUrl[] = 0;

                        echo $this->Html->link(
                            'Uncategorised',
                            $blogCategoryUrl
                        );
                    endif;
                    ?>
                </li>
            </ul>
        </div>
    </div>
</div>