<?php
App::uses('EvBlogAppController', 'EvBlog.Controller');

class BlogCategoriesController extends EvBlogAppController
{
	public function beforeFilter()
	{
		$this->Auth->allow('view');

		return parent::beforeFilter();
	}


	public function _adminFormFields()
	{
		$fields = parent::_adminFormFields();
		unset($fields['body']);

		return $fields;
	}

	public function view($id)
	{

		$Model = $this->{$this->modelClass};

		// Fall back incase no page is found
		$this->set('title_for_layout', "Blog");

		if ($id == 0) {

			$category = array(
				'BlogCategory' => array(
					'name' => 'Uncategorised'
				)
			);
			$category_id = null;

		} else {

			$category = $Model->findById($id);
			$category_id = $id;
		}
		$this->Meta->set($category);
		$this->set('category', $category);

		$this->paginate = array(
			'conditions' => array(
				'BlogPost.is_active' => 1,
				'BlogPost.posted <' => date('Y-m-d H:i:s'),
			),
			'order' => 'BlogPost.posted DESC',
			'contain' => array(
				'ListingImage',
				'BlogComment',
				'BlogCategory'
			),
			'joins' => array(
				array(
					'table' => 'blog_categories_blog_posts',
					'alias' => 'BlogCategoriesBlogPosts',
					'conditions' => array(
						'BlogCategoriesBlogPosts.blog_category_id' => $category_id,
						'BlogCategoriesBlogPosts.blog_post_id = BlogPost.id'
					),
					'group' => 'BlogCategoriesBlogPosts.blog_post_id'
				)
			),
			'limit' => 10
		);

		$this->loadModel('EvBlog.BlogPost');
		$this->set('data', $this->paginate('BlogPost'));

		// call the widgets
		$this->widgetLatestPosts();
		$this->widgetCategories();
		$this->widgetArchives();

		$this->view = 'EvBlog.BlogCategories/view';
	}
}
