<?php
    // define blog post url
    $blogPostUrl = $this->Route->getItemRoute('EvBlog', 'BlogPost');
    $blogPostUrl['action'] = 'view';
    $blogPostUrl[] = $blog['BlogPost']['id'];
?>
<div class="ev-blog__post">

    <?php if (! empty($blog['ListingImage'])): ?>

        <?php
            $img_path = '../' . $blog['ListingImage']['0']['filepath'];
            $img_alt = (! empty($blog['ListingImage']['0']['alt'])) ? $blog['ListingImage']['0']['alt'] : $blog['BlogPost']['name'];
        ?>

    <?php else: ?>

        <?php
            $img_path = '..' . DS . 'img' . DS . 'no-image.png';
            $img_alt = $blog['BlogPost']['name'];
        ?>

    <?php endif; ?>

    <?php
        $image = $this->Image->resize($img_path, array(
            'width' => 200,
            'height' => 145,
            'crop' => true,
            'alt' => $img_alt
        ));

         echo $this->Html->link($image, $blogPostUrl, array('escape' => false));
    ?>

    <div class="blogs-col">

        <div class="ev-blog__post__published">
            <?php
                echo $this->Time->format("jS F Y", $blog['BlogPost']['posted']);
            ?>
        </div>
        <h2 class="ev-blog__post__title">
            <?php
                echo $this->Html->link($blog['BlogPost']['name'], $blogPostUrl);
            ?>
        </h2>

        <div class="ev-blog__post__snippet">
            <p>
                <?php
                    echo stripslashes($blog['BlogPost']['snippet']);
                    echo $this->Html->link('Read More', array(
                        'plugin' => 'ev_blog',
                        'controller' => 'blog_posts',
                        'action' => 'view',
                        $blog['BlogPost']['id']
                    ));
                ?>
            </p>
        </div>

        <div class="ev-blog__meta">

            <dl>
                <dt class="ev-blog__meta__author">
                    Author
                </dt>
                <dd>
                    <?php echo $blog['BlogPost']['author']; ?>
                </dd>
                <?php
                    $commentUrl = Router::url($blogPostUrl) . '#blog-comments';
                ?>
                <dt class="ev-blog__meta__comments">
                    <?php
                        echo $this->Html->link(
                            'comments',
                            $commentUrl,
                            array(
                                'escape' => false
                            )
                        );
                    ?>
                </dt>
                <dd>
                    <?php
                        echo $this->Html->link(
                            (isset($blog['BlogComment'])) ? count($blog['BlogComment']) : '0',
                            $commentUrl,
                            array(
                                'escape' => false
                            )
                        );
                    ?>
                </dd>

                <dt class="ev-blog__meta__category">Category</dt>
                <?php if (isset($blog['BlogCategory']['name']) && ! empty($blog['BlogCategory']['name'])): ?>
                    <dd>
                        <?php
                            $blogCategoryUrl = $this->Route->getItemRoute('EvBlog', 'BlogCategory');
                            $blogCategoryUrl['action'] = 'view';
                            $blogCategoryUrl[] = $blog['BlogCategory']['id'];

                            echo $this->Html->link(
                                $blog['BlogCategory']['name'],
                                $blogCategoryUrl
                            );
                        ?>
                    </dd>
                <?php else: ?>
                    <dd>
                        <?php
                             $blogCategoryUrl = $this->Route->getItemRoute('EvBlog', 'BlogCategory');
                            $blogCategoryUrl['action'] = 'view';
                            $blogCategoryUrl[] = 0;

                            echo $this->Html->link(
                                'Uncategorised',
                                $blogCategoryUrl
                            );
                        ?>
                    </dd>
                <?php endif; ?>
            </dl>

        </div>
    </div>
</div>