<?php if (!empty($data['BlogPost']['hide_from_search_engines'])): ?>
	<?= $this->Html->meta([
		'name' => 'robots',
		'content' => 'noindex'
	], null, [
		'inline' => false
	]); ?>
<?php endif ?>

<div class="ev-blog__post">

    <div class="ev-blog__post__published">
        <?php echo $this->Time->format("jS F Y", $data['BlogPost']['posted']); ?>
    </div>

    <h1><?php echo h($data['BlogPost']['name']); ?></h1>

    <?php echo $data['BlogPost']['body']; ?>

    <?php if (isset($data['BlogTag']) && ! empty($data['BlogTag'])): ?>
        <p class="ev-blog__post__tags">
            <span>Tags:</span>

            <?php
                $tags = array();

                foreach ($data['BlogTag'] as $tag) {

                    $tagUrl = RouterUtil::getItemRoute('EvBlog', 'BlogTag');
                    $tagUrl[] = $tag['tag'];

                    $tags[] = $this->Html->link($tag['tag'], $tagUrl);
                }

                echo implode(', ', $tags);
            ?>

        </p>
    <?php endif; ?>

</div>

<div class="ev-blog__comments">

    <?php
        $comment_count = count($data['BlogComment']);
    ?>

    <a name="blog-comments"></a>

    <h2>
        <?php
            if ($comment_count > 1) {
                echo $comment_count . ' Comments';
            } elseif ($comment_count == 1) {
                echo '1 Comment';
            } else {
                echo 'No Comments';
            }
        ?>
    </h2>

    <?php if ($comment_count > 0): ?>

        <div class="ev-blog__comments__container">

            <?php foreach ($data['BlogComment'] as $comment): ?>

                <div class="ev-blog__comments__comment">
                    <a name="comment-<?php echo $comment['id']; ?>"></a>

                    <div class="ev-blog__comments__comment__image">
                        <?php

                            echo $this->Gravatar->get_gravatar(
                                $comment['email'],
                                58,
                                'mm',
                                'g',
                                true,
                                array(
                                    'alt' => $comment['author'] . ' Gravatar'
                                )
                            );
                        ?>
                    </div>

                    <div class="ev-blog__comments__comment__body">
                        <?php
                            echo '<span class="ev-blog__comments__comment__author">' . h($comment['author']) . '</h2>';
                            echo '<span class="ev-blog__comments__comment__published">' . $this->Time->format('F jS, Y \a\t H:i', $comment['created']) . '</h4>';
                            echo $comment['comment'];
                        ?>
                    </div>

                </div>

            <?php endforeach; ?>

        </div>

    <?php else: ?>

        <p>Be the first to comment!</p>

    <?php endif; ?>


    <h2>Leave a comment</h2>

    <?php
        echo $this->Session->flash('blog-comment');

        echo $this->Form->create('EvBlog.BlogComment', array(
            'url' => array(
                'plugin' => 'ev_blog',
                'controller' => 'blog_comments',
                'action' => 'post_comment'
            )
        ));

            // spam field :)
            echo $this->Form->input('email_confirm', array(
                'div' => array(
                    'style' => 'display: none;'
                )
            ));

            echo $this->Form->input('BlogComment.comment_id', array(
                'type' => 'text',
                'div' => false,
                'label' => false,
                'style' => 'display: none;'
            ));

            echo $this->Form->hidden('BlogComment.blog_post_id', array(
                'value' => $data['BlogPost']['id']
            ));

            echo $this->Form->input('BlogComment.author', array(
                'label' => 'Name',
                'div' => 'input col'
            ));

            echo $this->Form->input('BlogComment.email', array(
                'div' => 'input col'
            ));

            echo $this->Form->addField('BlogComment.comment', array(
                'type' => 'text_plain'
            ));

            echo '<div class="input submit">';
                echo $this->Form->button('Submit &raquo;', array(
                    'escape' => false
                ));
            echo '</div>';

        echo $this->Form->end();
    ?>
</div>

<div class="ev-blog__sidebar">
    <?php
        echo $this->Element('EvBlog.sidebar');
    ?>
</div>
