<?php echo $this->Html->css(array('EvBlog.admin_comments')); ?>
<div class='edit-form'>

	<div class='edit-form__header'>
		<h1 class='title'><?php echo $this->InflectorExt->pluralize($displayName); ?> <span>Administration</span></h1>
		<h2 class='title edit-form__title'>
			<?php
				if (isset($title_for_layout)):

					echo $title_for_layout;

				else:

					echo $this->InflectorExt->humanize(preg_replace('|^admin_|i', '', $this->request->action));
					echo $this->InflectorExt->humanize($displayName);

				endif;
			?>
		</h2>

		<?php echo $this->Element('toolbar'); ?>
	</div>

	<?php

		echo $this->Html->script('admin_form', array('inline'=>false));

		echo $this->Form->create(null, array(
			'inputDefaults'=>array(
				'empty'=>''
			),
			'type' => 'file',
			'class' => 'cr'
		));

	?>

	<div class='tab__content' data-title='Content'>
		<?php if($content = $this->fetch('content')): ?>
			<?php echo $content; ?>
		<?php else: ?>
			<?php echo $this->Element('Forms/fields', array('fields' => $fields)); ?>
		<?php endif; ?>
	</div>

	<?php if(isset($imageSlots) && is_array($imageSlots)): //We have multiple image sections on a page ?>
		<?php foreach($imageSlots as $imageSection=>$imageSlots): ?>

			<div class='tab__content' data-title='Images - <?php echo $this->InflectorExt->humanize($imageSection); ?>'>
				<?php
					echo $this->Element(
						'Forms/image_fields',
						array(
							'imageSection' => $imageSection,
							'imageSlots' => $imageSlots
						)
					);
				?>
			</div>
		<?php endforeach; ?>

	<?php elseif (isset($imageSlots) && $imageSlots!=0): ?>
		<div class='tab__content' data-title='Images'>
			<?php
				echo $this->Element(
					'Forms/image_fields',
					array(
						'imageSection' => 'main'
					)
				);
			?>
		</div>
	<?php endif ?>

	<?php if (isset($documentSlots) && $documentSlots>0): ?>
		<div class='tab__content' data-title='Documents'>
			<?php echo $this->Element('Forms/document_fields'); ?>
		</div>
	<?php endif ?>

	<?php if (isset($menuFields) && !empty($menuFields)): ?>
		<div class='tab__content' data-title='Menu'>
			<?php echo $this->Element('Forms/fields', array('fields' => $menuFields)); ?>
		</div>
	<?php endif ?>

	<?php if (isset($metaData) && !empty($metaData)): ?>
		<div class='tab__content' data-title='Meta Data'>
			<?php echo $this->Element('Forms/fields', array('fields' => $metaData)); ?>
		</div>
	<?php endif ?>

	<div class="tab__content" data-title="Comments">
		<?php echo $this->Element('EvBlog.admin-blog-comments'); ?>
	</div>


	<div class="input checkbox">
		<input type="hidden" name="return" id="return_" value="0">
		<input type="checkbox" name="return" null="1" length="1" value="1" id="return">
		<label for="return">Return after saving</label>
	</div>

	<?php echo $this->Element('Forms/form_submit'); ?>

	<?php echo $this->Form->end(); ?>

</div>