<?php
App::uses('EvBlogAppModel', 'EvBlog.Model');

class BlogComment extends EvBlogAppModel
{
	public $displayField = 'author';

	public $belongsTo = array(
		'BlogPost' => array(
			'className' => 'EvBlog.BlogPost'
		)
	);

	public $validate = array(
		'blog_post_id' => array(
			'notempty' => array(
				'rule' => array('notempty')
			),
		),
		'author' => array(
			'notempty' => array(
				'rule' => array('notempty')
			),
		),
		'comment' => array(
			'notempty' => array(
				'rule' => array('notempty')
			),
		)
	);

}
