<?php

class EvBlogAppController extends AppController
{

	public $helpers = array(
		'EvBlog.Gravatar'
	);

	public function beforeFilter()
	{
		parent::beforeFilter();

		$this->BlogWidgets = $this->Components->load('EvBlog.BlogWidgets');
	}

	public function widgetLatestPosts($limit = 3)
	{
		$latest_posts = $this->BlogWidgets->latestPosts($limit);

		$view = new View($this, false);
		$view->loadHelper('Routable.Route');
		$view->set('latest_posts', $latest_posts);
		$output = $view->render('EvBlog.Widgets/latest_posts', false);

		$this->set('blogplugin_widget_latestposts', $output);
	}

	public function widgetCategories($limit = null)
	{
		$categories = $this->BlogWidgets->categories($limit);

		$view = new View($this, false);
		$view->loadHelper('Routable.Route');
		$view->set('categories', $categories);
		$output = $view->render('EvBlog.Widgets/categories', false);

		$this->set('blogplugin_widget_categories', $output);
	}

	public function widgetArchives($limit = 12)
	{
		$dates = $this->BlogWidgets->archives($limit);

		$view = new View($this, false);
		$view->loadHelper('Routable.Route');
		$view->set('dates', $dates);
		$output = $view->render('EvBlog.Widgets/archives', false);

		$this->set('blogplugin_widget_archives', $output);
	}

}

