<?php

App::uses('Component', 'Controller');

class BlogWidgetsComponent extends Component
{
	private $__controller = null;

	/**
	 * Sets a reference to the calling controller from within the component.
	 *
	 * @see Component::initialize()
	 */
	public function initialize(Controller $controller) {

		parent::initialize($controller);

		$this->__controller = $controller;

	}

	public function latestPosts($limit = 3)
	{
		$this->BlogPost = ClassRegistry::init('EvBlog.BlogPost');

		return $this->BlogPost->find('all', array(
			'conditions' => array(
				'BlogPost.is_active' => 1,
				'BlogPost.posted <' => date('Y-m-d H:i:s')
			),
			'order' => 'BlogPost.posted DESC',
			'limit' => $limit,
			'contain' => array(
				'ListingImage'
			)
		));
	}


	public function categories($limit = null)
	{
		$this->BlogCategory = ClassRegistry::init('EvBlog.BlogCategory');
		$this->BlogPost = ClassRegistry::init('EvBlog.BlogPost');

		$params = array(
			'conditions' => array(
				'BlogCategory.is_active' => 1
			),
			'order' => 'BlogCategory.name ASC'
		);

		if (! empty($limit)) {

			$params['limit'] = $limit;
		}

		$categories = array(
			array(
				'BlogCategory' => array(
					'id' => 0,
					'name' => 'Uncategorised'
				)
			)
		);

		$data = $this->BlogCategory->find('all', $params);
		$categories = array_merge($categories, $data);

		foreach ($categories as $k => $category) {

			if ($category['BlogCategory']['id'] == 0) {

				$category['BlogCategory']['id'] = null;
			}

			$count = $this->BlogPost->find('count', array(
				'conditions' => array(
					'BlogPost.is_active' => 1,
					'BlogPost.blog_category_id' => $category['BlogCategory']['id'],
					'BlogPost.posted <' => date('Y-m-d H:i:s')
				)
			));

			if ($count > 0) {

				$categories[$k]['BlogCategory']['name'] .= ' (' . $count . ')';
			} else {

				unset($categories[$k]);
			}
		}

		return $categories;
	}


	public function archives($limit = 12)
	{
		$this->BlogPost = ClassRegistry::init('EvBlog.BlogPost');

		$dates = array();
		$time = time();
		$last_day = array();
		$today = date('Y-m-t');

		for ($i = 0;$i < $limit;$i++) {

			$dates[date('Y-m-t', $time)] = date('F Y', $time);

			$time = strtotime('-1 Month', $time);
		}

		foreach ($dates as $date => $display) {

			$date_bits = explode('-', $date);
			$date_short = $date_bits['0'] . '-' . $date_bits['1'];

			$count = $this->BlogPost->find('count', array(
				'conditions' => array(
					'BlogPost.is_active' => 1,
					'BlogPost.posted >=' => $date_short . '-01 00:00:00',
					'BlogPost.posted <=' => $date . ' 23:59:59',
					'BlogPost.posted <' => date('Y-m-d H:i:s')
				)
			));

			if ($count > 0) {

				$dates[$date] .= ' (' . $count . ')';
			} else {

				unset($dates[$date]);
			}
		}

		return $dates;
	}

}
