<?php
App::uses('EvBlogAppController', 'EvBlog.Controller');

class BlogTagsController extends EvBlogAppController
{
	public function beforeFilter()
	{
		$this->Auth->allow('view');

		return parent::beforeFilter();
	}

	public function view($tag)
	{
		// Fall back incase no page is found
		$this->set('title_for_layout', "Blog");

		$tag_details = array(
			'BlogTag' => array(
				'name' => 'Tag Search: ' . $tag
			)
		);

		$this->Meta->set($tag_details);
		$this->set('tag_details', $tag_details);

		$this->paginate = array(
			'conditions' => array(
				'BlogPost.is_active' => 1,
				'BlogPost.posted <' => date('Y-m-d H:i:s'),
				'BlogTag.tag' => $tag
			),
			'order' => 'BlogPost.posted DESC',
			'contain' => array(
				'ListingImage',
				'BlogComment',
				'BlogCategory'
			),
			'limit' => 10,
			'group' => 'BlogPost.id',
			'joins' => array(
				array(
					'table' => 'blog_blog_tags',
					'alias' => 'BlogTag',
					'type' => 'LEFT',
					'conditions' => array(
						'BlogPost.id = BlogTag.blog_post_id'
					)
				)
			)
		);

		$this->loadModel('EvBlog.BlogPost');
		$this->set('data', $this->paginate('BlogPost'));

		// call the widgets
		$this->widgetLatestPosts();
		$this->widgetCategories();
		$this->widgetArchives();

		$this->view = 'EvBlog.BlogTags/view';
	}
}
