<?php
class AddHiddenFromSearchEngineField extends CakeMigration {

	/**
	 * Migration description
	 *
	 * @var string
	 */
	public $description = 'add_hidden_from_search_engine_field';

	/**
	 * Actions to be performed
	 *
	 * @var array $migration
	 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_blog_blog_posts' => array(
					'hide_from_search_engines' => array('type' => 'boolean', 'null' => false, 'default' => false, 'after' => 'is_active'),
				)
			)
		),
		'down' => array(
			'drop_field' => array(
				'ev_blog_blog_posts' => array(
					'hide_from_search_engines',
				)
			)
		),
	);

	/**
	 * Before migration callback
	 *
	 * @param string $direction Direction of migration process (up or down)
	 * @return bool Should process continue
	 */
	public function before($direction) {
		return true;
	}

	/**
	 * After migration callback
	 *
	 * @param string $direction Direction of migration process (up or down)
	 * @return bool Should process continue
	 */
	public function after($direction) {
		return true;
	}
}