<?php

class Bitly {

	protected static $_instance = null; //The current bitly instace.

/**
 * Create a bitly instance.
 *
 * @return obj The instance created.
 */
	protected static function _createInstance() {
		$accessToken = '';

		if (Configure::read('app.environment') == 'PRODUCTION') {
			$accessToken = Configure::read('EvBitly.live.accessToken');
		} else {
			$accessToken = Configure::read('EvBitly.dev.accessToken');
		}

		if (!empty($accessToken)) {
			try {
				self::$_instance = new \LeadThread\Bitly\Bitly($accessToken);
			} catch (Exception $e) {
				CakeLog::write('bitly', 'Could not create bitly instance with access token: ' . $accessToken . ' ' . $e->getMessage());
			}
		} else {
			CakeLog::write('bitly', 'Access token is missing');
		}

		return self::$_instance;
	}

/**
 * Shorten a url using the Bitly api.
 *
 * @param string $url The url to shorten.
 * @return string The shortened url. If the url couldn't be shortened then the original url is returned.
 */
	public static function shorten($url) {
		$shortUrl = $url;

		if (empty(self::$_instance)) {
			if (!self::_createInstance()) {
				return $shortUrl;
			}
		}

		try {
			$shortUrl = self::$_instance->shorten($url);
		} catch (Exception $e) {
			CakeLog::write('bitly', 'Short url could not be generated for: ' . $url . ' ' . $e->getMessage());
		}

		return $shortUrl;
	}
}
