<?php

$path = dirname(__FILE__);
$pluginDirectory = explode(DS, dirname($path . '../'));

$pluginName = array_pop($pluginDirectory);
$pluginConfig = Inflector::underscore($pluginName);

Configure::load($pluginName . '.config');

// Load overrides to settings if they exist
$configOverridePath = APP . 'Config' . DS;
$configOverride = 'Plugin' . DS . $pluginConfig . '.php';
if (file_exists($configOverridePath . $configOverride) && is_readable($configOverridePath . $configOverride)) {
	Configure::load($configOverride);
}

CakeLog::levels(array('bitly'));
CakeLog::config('bitly', array(
	'engine' => 'FileLog',
	'types' => array('bitly'),
	'file' => 'bitly',
));
