<?php
/**
 * BasketTotal Fixture
 */
class BasketTotalFixture extends CakeTestFixture {

	public $table = 'ev_basket_basket_totals';

/**
 * Fields
 *
 * @var array
 */
	public $fields = array(
		'id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'primary'),
		'basket_id' => array('type' => 'integer', 'null' => false, 'default' => null, 'length' => 10, 'unsigned' => false, 'key' => 'index'),
		'name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4'),
		'amount' => array('type' => 'decimal', 'null' => true, 'default' => '0.000000', 'length' => '12,6', 'unsigned' => false),
		'sequence' => array('type' => 'integer', 'null' => true, 'default' => null, 'length' => 5, 'unsigned' => false),
		'is_grand_total' => array('type' => 'boolean', 'null' => true, 'default' => null),
		'created' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'modified' => array('type' => 'datetime', 'null' => true, 'default' => null),
		'indexes' => array(
			'PRIMARY' => array('column' => 'id', 'unique' => 1),
			'fk_basket_totals_baskets1_idx' => array('column' => 'basket_id', 'unique' => 0)
		),
		'tableParameters' => array('charset' => 'utf8mb4', 'collate' => 'utf8mb4_general_ci', 'engine' => 'InnoDB')
	);

/**
 * Records
 *
 * @var array
 */
	public $records = array(
		array(
			'id' => 1,
			'basket_id' => 1,
			'name' => 'Grand Total',
			'amount' => '28.50',
			'sequence' => 30,
			'is_grand_total' => 1,
			'created' => '2015-08-17 09:00:17',
			'modified' => '2015-08-17 09:00:17'
		),
		array(
			'id' => 2,
			'basket_id' => 1,
			'name' => 'Sub Total',
			'amount' => '25.50',
			'sequence' => 10,
			'is_grand_total' => 0,
			'created' => '2015-08-17 09:00:17',
			'modified' => '2015-08-17 09:00:17'
		),
		array(
			'id' => 3,
			'basket_id' => 1,
			'name' => 'Delivery',
			'amount' => '3.00',
			'sequence' => 20,
			'is_grand_total' => 0,
			'created' => '2015-08-17 09:00:17',
			'modified' => '2015-08-17 09:00:17'
		)
	);

}
