<?php
App::uses('EvBasketAppModel', 'EvBasket.Model');

class BasketItemData extends EvBasketAppModel {

	public $belongsTo = [
		'BasketItem' => [
			'className' => 'BasketItem',
			'foreignKey' => 'basket_item_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		]
	];

/**
 * Set a data row for the basket item (updates or creates one based on the basket item id and name).
 *
 * @param int    $basketItemId Id of the basket that the record belongs to.
 * @param string $name         Name of the data row.
 * @param string $data         Value of the data row.
 * @return bool True is saved successfully, false otherwise.
 */
	public function setItemData($basketItemId, $name, $data) {
		$record = $this->checkForExistingData($basketItemId, $name);

		if ($record !== false) {
			$this->set('id', $record);
		} else {
			$this->clear();
		}

		$this->set([
			'basket_item_id' => $basketItemId,
			'name' => $name,
			'item_data' => $data
		]);

		return $this->save();
	}

/**
 * Check if there is any existing item data for the basket item with the provided name. If there is
 * then return the id of the basket item data, otherwise return false.
 *
 * @param int    $basketItemId The id of the basket item to check for data on.
 * @param string $itemDataName The name of the basket item data to check for.
 * @return int|bool The id of the basket item data if found, false otherwise.
 */
	public function checkForExistingData($basketItemId, $itemDataName) {
		$existingData = $this->find(
			'first',
			[
				'conditions' => [
					$this->alias . '.basket_item_id' => $basketItemId,
					$this->alias . '.name' => $itemDataName,
				]
			]
		);

		if (!empty($existingData[$this->alias]['id'])) {
			return $existingData[$this->alias]['id'];
		}

		return false;
	}

}
