<?php

App::uses('CakeEventListener', 'Event');

App::uses('CakeLog', 'Log');

class EvBasketClearUserCookieListener implements CakeEventListener {

/**
 * Implements events
 *
 * @return array of events => callbacks
 */
	public function implementedEvents() {
		return array(
			'Auth.afterLogout' => 'clearBasketCookie'
		);
	}

/**
 * Clears the current basket cookie associated with the users
 *
 * @param CakeEvent $Event The event
 * @return bool
 */
	public function clearBasketCookie(CakeEvent $Event) {
		$BasketCookie = $Event->subject()->_controller->loadComponent('EvBasket.BasketCookie');
		$BasketCookie->write('basketHash', false);

		$BasketManager = $Event->subject()->_controller->loadComponent('EvBasket.Basket');
		$BasketManager->resetBasket();

		return true;
	}
}
