<?php
App::uses('CakeEventListener', 'Event');
App::uses('CakeLog', 'Log');

class EvBasketCheckForOrderSuccessListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCheckout.Controller.Order.success' => 'clearBasketDropoutData'
		);
	}

/**
 * Check the session for basket dropout data. Delete the key if it exists at this point.
 *
 * @param 	CakeEvent
 */
	public function clearBasketDropoutData(CakeEvent $Event) {
		// delete any basket dropout session data at this point
		if ($Event->subject()->Session->check('dropoutBasketData')) {
			$Event->subject()->Session->delete('dropoutBasketData');
		}

		return true;
	}
}
