<?php

App::uses('CakeEventListener', 'Event');
App::uses('CakeLog', 'Log');
class EvBasketCheckForCurrencyChangeListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCurrency.Component.Currencies.setCurrency' => 'currencyChange'
		);
	}

/**
 * Actions to perform on currency change
 *
 * @param CakeEvent $Event the current event
 * @return bool
 */
	public function currencyChange(CakeEvent $Event) {
		// For when BasketCookie doesn't exist - i.e. first visit
		if (! isset($Event->subject()->_controller->BasketCookie)) {
			return false;
		}
		// Once a currency change happens, the basket is no longer useable.
		// Set the cookie to null as we need a new basketCookie, deleting or destroying doesn't work until page load
		$Event->subject()->_controller->BasketCookie->write('basketHash', null);

		// Reset the basketCache to null so that all values are new
		$Event->subject()->_controller->BasketManager->resetBasket();

		// Setup the hash and save it into the basketCookie. A new basket is also created and saved into the basketCache.
		$hash = $Event->subject()->_controller->BasketManager->setupHash();

		return true;
	}
}
