<?php

App::uses('PluginInstallShell', 'shells');
App::uses('File', 'Utility');

class EvBasketInstallShell extends PluginInstallShell {

	public $uses = array(
		'EvTemplates.Template',
		'EvCore.Page',
		'EvSiteSettings.SiteSetting',
		'EvSiteSettings.SiteSettingCategory'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		$date = date('Y-m-d H:i:s');

		// add all the base temoplates
		$this->Template->save(
			array(
				'Template' => array(
					'name' => 'Basket',
					'template' => 'EvBasket./Templates/Basket/index',
					'helperFunction' => 'N/A',
					'cfDataLabel' => 'Custom Data',
					'model' => 'Page',
					'is_active' => 1,
					'created' => $date,
					'modified' => $date
				)
			)
		);
		$templateIds = $this->Template->find('list', array('callbacks' => false, 'limit' => 1, 'order' => 'Template.id DESC'));
		$templateIds = array_flip($templateIds);

		$this->Page->save(
			array(
				'Page' => array(
					'title' => 'Basket',
					'internal_title' => 'basket',
					'is_active' => 1,
					'is_protected' => 1,
					'template_id' => $templateIds['Basket'],
					'created' => $date,
					'modified' => $date
				)
			)
		);
		$pageIds = $this->Page->find('list', array('callbacks' => false, 'limit' => 1, 'order' => 'Page.id DESC'));
		$pageIds = array_flip($pageIds);

		// Add the site settings category
		$this->SiteSettingCategory->save(
			array(
				'SiteSettingCategory' => array(
					'name' => 'Basket',
					'array_slug' => 'ev_basket',
					'sequence' => 16,
					'prevent_edit' => 0
				)
			)
		);
		$parentId = $this->SiteSettingCategory->getInsertID();

		// Add the site settings
		$this->SiteSetting->saveMany(
			array(
				array(
					'SiteSetting' => array(
						'name' => 'Delivery tax rate',
						'array_slug' => 'delivery_tax_rate',
						'type' => 'string',
						'value' => 20.00,
						'sequence' => 10,
						'site_setting_category_id' => $parentId,
						'prevent_edit' => 0
					)
				),
				array(
					'SiteSetting' => array(
						'name' => 'Discounts Include Tax',
						'array_slug' => 'discounts_include_tax',
						'type' => 'boolean',
						'value' => 0,
						'sequence' => 20,
						'site_setting_category_id' => $parentId,
						'prevent_edit' => 0
					)
				)
			)
		);

		// write to the plugin config
		$configContents = '<?php

$config = array(
	\'EvBasket\' => array(
		/**
		 * the content oage id to use as an intro for the basket
		 */
		\'pageId\' => ' . $pageIds['Basket'] . '
	)
);';

		$File = new File(APP . 'Config/Plugin/ev_basket.php', true);
		$File->write($configContents);
	}
}
