<?php

App::uses('AppShell', 'Console/Command');
App::uses('BasketLib', 'EvBasket.Lib');

class BasketsShell extends AppShell {

	public $uses = array('EvBasket.Basket');

/**
 * Run basket clean up to remove any old baskets
 */
	public function cleanUp() {
		$deletedItems = BasketLib::cleanBaskets();

		$this->out($deletedItems . ' item(s) deleted');
	}

/**
 * Clear all the baskets out and associated tables by truncating them. Truncated in order to stop any
 * foreign key constraint issues.
 *
 * WARNING!! WARNING!! WARNING!!
 *
 * This will remove all baskets currently in use by users who are accessing the site. It will also
 * effect users who are currently in the process of checking out as their baskets will be removed
 * before it can be turned into an order. It is strongly recommended to not run this on a live site.
 * This command is intended to be run on development sites to remove old baskets that are missing
 * required data.
 *
 * @return void.
 */
	public function destroyAllBaskets() {
		$Basket = EvClassRegistry::init('EvBasket.Basket');
		$dataSource = $Basket->getDataSource();

		//Clear basket item data.
		$tableName = $dataSource->fullTableName($Basket->BasketItem->BasketItemData);
		$dataSource->truncate($tableName);

		//Clear basket items.
		$tableName = $dataSource->fullTableName($Basket->BasketItem);
		$dataSource->truncate($tableName);

		//Clear basket data.
		$tableName = $dataSource->fullTableName($Basket->BasketData);
		$dataSource->truncate($tableName);

		//Clear basket totals.
		$tableName = $dataSource->fullTableName($Basket->BasketTotal);
		$dataSource->truncate($tableName);

		//Clear baskets.
		$tableName = $dataSource->fullTableName($Basket);
		$dataSource->truncate($tableName);
	}
}
