<?php

App::uses('CakeEventManager', 'Event');

class EvBasketEvents {

	protected $_plugin = 'EvBasket';

	protected $_path = 'Lib/Event';

	protected $_events = [
		'EvBasketCheckForDiscountListener',
		'EvBasketCheckForCurrencyChangeListener',
		'EvBasketClearUserCookieListener',
		'EvBasketCheckForOrderSuccessListener',
	];

/**
 * Construct the events.
 */
	public function __construct() {
		$this->_attachEvents();
	}

/**
 * Attach the current events to the CakeEventManager.
 *
 * @return void.
 */
	protected function _attachEvents() {
		foreach ($this->_events as $event) {
			//Check for extended event
			$className = $this->_plugin . $event;
			App::uses($className, $this->_path . DS . $this->_plugin);

			if (class_exists($className)) {
				CakeEventManager::instance()->attach(
					new $className
				);
				continue;
			}

			//Attach plugin event
			$className = $event;
			App::uses($className, $this->_plugin . '.' . $this->_path);
			if (class_exists($className)) {
				CakeEventManager::instance()->attach(
					new $className
				);
			}
		}
	}

}

new EvBasketEvents();
