<?php

class AddingMissingBasketTableIndexes extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'adding_missing_basket_table_indexes';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_basket_basket_items' => array(
					'indexes' => array(
						'fk_basket_items_model_model_id' => array('column' => array('model', 'model_id'), 'unique' => false),
					),
				),
				'ev_basket_basket_item_data' => array(
					'indexes' => array(
						'fk_basket_item_data_basket_item_id' => array('column' => 'basket_item_id', 'unique' => false),
						'basket_item_data_name' => array('column' => 'name', 'unique' => false),
					),
				),
				'ev_basket_basket_dropouts' => array(
					'indexes' => array(
						'fk_basket_dropouts_user_id' => array('column' => 'user_id', 'unique' => false),
						'fk_basket_dropouts_basket_hash' => array('column' => 'basket_hash', 'unique' => false),
					),
				),
				'ev_basket_basket_data' => array(
					'indexes' => array(
						'basket_data_name' => array('column' => 'name', 'unique' => false),
					),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'ev_basket_basket_items' => array(
					'indexes' => array(
						'fk_basket_items_model_model_id',
					),
				),
				'ev_basket_basket_item_data' => array(
					'indexes' => array(
						'fk_basket_item_data_basket_item_id',
						'basket_item_data_name',
					),
				),
				'ev_basket_basket_dropouts' => array(
					'indexes' => array(
						'fk_basket_dropouts_user_id',
						'fk_basket_dropouts_basket_hash',
					),
				),
				'ev_basket_basket_data' => array(
					'indexes' => array(
						'basket_data_name',
					),
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
