<?php
App::uses('Basket', 'EvBasket.Model');

/**
 * Basket Test Case
 */
class BasketTest extends CakeTestCase {

	/**
	 * Fixtures
	 *
	 * @var array
	 */
	public $fixtures = array(
		'plugin.ev_basket.basket',
		'plugin.ev_basket.basket_item',
		'plugin.ev_basket.basket_total',
		'plugin.ev_basket.test_model'
	);

	/**
	 * setUp method
	 *
	 * @return void
	 */
	public function setUp() {
		parent::setUp();
		Configure::write(
			'EvBasket.BasketItemBelongsTo',
			array(
				'TestModel' => array(
					'className' => 'EvBasket.TestModel',
					'foreignKey' => 'model_id',
					'conditions' => array(
						"BasketItem.model = 'EvBasket.TestModel'"
					)
				)
			)
		);

		$this->Basket = ClassRegistry::init('EvBasket.Basket');
	}

	/**
	 * tearDown method
	 *
	 * @return void
	 */
	public function tearDown() {
		unset($this->Basket);

		parent::tearDown();
	}

	public function testCheckExistsReturnsTrueWhenValidHashGivenAndFalseWhenNot() {
		$this->assertTrue(
			$this->Basket->checkExists('55d1f4ad-0e40-475f-b4c0-40d7c0a83886')
		);

		$this->assertFalse(
			$this->Basket->checkExists('68838a0c7d04-0c4b-f574-04e0-da4f1d55')
		);
	}

	public function testGetFullBasketReturnsFullBasketArray() {
		$this->assertEquals(
			array(
				'Basket' => array(
					'id' => 1,
					'hash' => '55d1f4ad-0e40-475f-b4c0-40d7c0a83886',
					'created' => '2015-08-17 08:58:06',
					'modified' => '2015-08-17 08:58:06'
				),
				'BasketItem' => array(
					'EvBasket.TestModel.1' => array(
						'id' => '1',
						'basket_id' => '1',
						'model' => 'EvBasket.TestModel',
						'model_id' => '1',
						'unit_price' => '10.000000',
						'quantity' => '2',
						'row_total' => '20.000000',
						'created' => '2015-08-17 08:59:29',
						'modified' => '2015-08-17 08:59:29',
						'TestModel' => array(
							'id' => '1',
							'name' => 'A Test Record',
							'created' => '2015-07-20 16:14:47',
							'modified' => '2015-07-20 16:14:47'
						)
					),
					'EvBasket.TestModel.2' => array(
						'id' => '2',
						'basket_id' => '1',
						'model' => 'EvBasket.TestModel',
						'model_id' => '2',
						'unit_price' => '5.500000',
						'quantity' => '1',
						'row_total' => '5.500000',
						'created' => '2015-08-17 08:59:29',
						'modified' => '2015-08-17 08:59:29',
						'TestModel' => array(
							'id' => '2',
							'name' => 'A Test Record Number two',
							'created' => '2015-07-20 16:14:47',
							'modified' => '2015-07-20 16:14:47'
						)
					)
				),
				'BasketTotal' => array(
					'2' => array(
						'id' => '2',
						'basket_id' => '1',
						'name' => 'Sub Total',
						'amount' => '25.500000',
						'sequence' => '10',
						'is_grand_total' => false,
						'created' => '2015-08-17 09:00:17',
						'modified' => '2015-08-17 09:00:17'
					),
					'3' => array(
						'id' => '3',
						'basket_id' => '1',
						'name' => 'Delivery',
						'amount' => '3.000000',
						'sequence' => '20',
						'is_grand_total' => false,
						'created' => '2015-08-17 09:00:17',
						'modified' => '2015-08-17 09:00:17'
					),
					'1' => array(
						'id' => '1',
						'basket_id' => '1',
						'name' => 'Grand Total',
						'amount' => '28.5000000',
						'sequence' => '30',
						'is_grand_total' => true,
						'created' => '2015-08-17 09:00:17',
						'modified' => '2015-08-17 09:00:17'
					)
				)
			),
			$this->Basket->getFullBasket(
				'55d1f4ad-0e40-475f-b4c0-40d7c0a83886',
				array(
					'TestModel'
				)
			)
		);
	}

	public function testCreateBasketCreatesAndReturnsTrueAndFalseWhenADuplicateHashGiven() {
		$this->assertTrue(
			$this->Basket->createBasket('68838a0c7d04-0c4b-f574-04e0-da4f1d55')
		);

		$this->assertFalse(
			$this->Basket->createBasket('68838a0c7d04-0c4b-f574-04e0-da4f1d55')
		);
	}
}
