<?php

App::uses('CakeEventListener', 'Event');

class EvBasketCheckForDiscountListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvDiscount.Component.DiscountCodes.codeAdded' => 'addDiscount',
			'EvBasket.Component.Basket.itemAdd' => 'rebuildDiscount',
			'EvBasket.Component.Basket.itemUpdated' => 'rebuildDiscount',
			'EvBasket.Component.Basket.itemDeleted' => 'rebuildDiscount'
		);
	}

	/**
	 * queue up the confirmation emails
	 *
	 * @param 	CakeEvent
	 */
	public function addDiscount(CakeEvent $Event) {
		// Event subject will be the EvDiscount.DiscountCodesComponent
		return $this->rebuildDiscount($Event);
	}

	/**
	 * rebuild discount due to basket amends
	 *
	 * @param 	CakeEvent
	 */
	public function rebuildDiscount(CakeEvent $Event) {
		if (! CakePlugin::loaded('EvDiscount')) {
			return false;
		}

		App::uses('DiscountLib', 'EvDiscount.Lib');

		$DiscountCode = EvClassRegistry::init('EvDiscount.DiscountCode');

		$EventSubject = $Event->subject();

		if (! is_object($EventSubject->_controller->DiscountCookie)) {
			$EventSubject->_controller->DiscountCookie = $EventSubject->_controller->loadComponent('EvDiscount.DiscountCookie');
		}

		// try to read the cookies
		$codeCookie = $EventSubject->_controller->DiscountCookie->read('Code');

		if (! empty($codeCookie) && is_array($codeCookie)) {
			$validCodes = $DiscountCode->validateCodes($codeCookie);
		}

		if (! is_object($EventSubject->_controller->BasketManager)) {
			$EventSubject->_controller->BasketManager = $EventSubject->_controller->loadComponent('EvBasket.BasketManager');
		}

		$total = 0;
		$tax = 0;
		$basket = $EventSubject->_controller->BasketManager->getBasket();

		foreach ($basket['BasketItem'] as $basketItem) {
			$total += $basketItem['row_total'];
			$tax += $basketItem['row_tax_amount'];
		}
		if ($total > 0) {
			$averageTaxRate = $tax / $total;
		} else {
			$averageTaxRate = 0;
		}

		$discount = 0;
		$failedCodes = 0;
		$totalRemaining = $total;

		if (! empty($validCodes) && is_array($validCodes)) {
			foreach ($validCodes as $codeData) {
				if (!empty($codeData['DiscountCode']['min_order']) && $total < $codeData['DiscountCode']['min_order']) {
					$failedCodes++;
					continue;
				}

				if ($totalRemaining <= 0) {
					// Nothing else left to discount
					continue;
				}

				$amount = DiscountLib::calculate($codeData, $total);

				$discountTax = 0;
				if (! empty($amount) && Configure::read('SiteSetting.ev_basket.discounts_include_tax')) {
					if ($codeData['DiscountCode']['discount_type_id'] == DiscountLib::PERCENTAGE_DISCOUNT) {
						$discount += $amount;
					} else {
						// Get the amount capped at the current remaining subtotal + tax
						$amount = min($amount, $totalRemaining * (1 + $averageTaxRate));
						$discountTax = ($amount / (1 + $averageTaxRate)) * $averageTaxRate;
						$amount -= $discountTax;
						$discount += $amount;
					}
				} else {
					$amount = min($amount, $totalRemaining);
					$discount += $amount;
				}

				$totalRemaining -= $amount;
			}

			// failed codes represent that a code could be valid date and usage wise, but
			// still have a min order value under what the current basket is. in that scenario,
			// this listener needs to return false
			// we count the number of failed codes as there could be multiple codes with the same "code",
			// and one of them is valid, etc.
			if (!empty($validCodes) && $failedCodes == count($validCodes)) {
				return false;
			}
		}

		if (! empty($discount) && $discount > 0) {

			$EventSubject->_controller->BasketManager->manageTotalRow(
				Configure::read('EvBasket.labels.discount'),
				-$discount,
				15
			);

			$Event->subject()->_controller->BasketManager->rebuildTotals();
		}

		return true;
	}
}
